package com.kms.katalon.core.webui.authentication.basic;

import java.net.URL;

import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.module.Network;
import org.openqa.selenium.bidi.network.AddInterceptParameters;
import org.openqa.selenium.bidi.network.InterceptPhase;

import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.util.UrlUtil;

public class BiDiBasicAuth implements BasicAuthenticationStrategy {

    @Override
    public boolean navigate(URL url, String username, String password, int timeout) {
        WebDriver driver = DriverFactory.getWebDriver();
        try (Network network = new Network(driver)) {
            network.addIntercept(new AddInterceptParameters(InterceptPhase.AUTH_REQUIRED));
            network.onAuthRequired(
                responseDetails -> network.continueWithAuth(
                    responseDetails.getRequest().getRequestId(),
                    new UsernameAndPassword(username, password)
                )
            );

            driver.navigate().to(url.toString());
            
            return UrlUtil.assertUrlsWithoutProtocol(url.toString(), driver.getCurrentUrl());
        }
    }

}
