package com.kms.katalon.core.webui.driver.edge;

import java.io.File;
import java.io.IOException;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;

import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.driver.chromium.ChromiumDriverBuilder;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.selenium.driver.CEdgeDriver;

public class EdgeChromiumDriverBuilder extends ChromiumDriverBuilder {
    @Override
    protected AbstractDriverOptions<?> createOptions(Capabilities capabilities) {
        return new EdgeOptions().merge(capabilities);
    }

    @Override
    protected WebDriver createDriver(AbstractDriverOptions<?> options) {
        if (!(options instanceof EdgeOptions edgeOptions)) {
            return null;
        }

        var service = new EdgeDriverService.Builder()
                .usingDriverExecutable(new File(EdgeDriverUtil.getEdgeChromiumDriverPath()))
                .usingAnyFreePort()
                .build();
        return new CEdgeDriver(service, edgeOptions, driverConfigProvider.getActionDelayInMilisecond());
    }

    @Override
    protected AbstractDriverOptions<?> addExtension(AbstractDriverOptions<?> options, String extensionPath)
            throws IOException {
        boolean installedKcu = WebDriverPropertyUtil
                .didUserProfileInstallKatalonCompactUtility(WebUIDriverType.EDGE_CHROMIUM_DRIVER, capabilities);

        if (installedKcu) {
            return options;
        }

        if (!(options instanceof EdgeOptions edgeOptions)) {
            return options;
        }

        var extension = new File(FileUtil.getExtensionsDirectory(), extensionPath);
        edgeOptions.addExtensions(extension);
        return edgeOptions;
    }
}
