package com.kms.katalon.core.aut;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class WebAUT implements ApplicationUnderTest {
    private WebDriver driver;

    protected WebDriver getDriver() {
        return driver;
    }

    public WebAUT(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public boolean isReady() {
        return getDriver() != null;
    }

    @Override
    public String getPageSource() throws Exception {
        return this.getDriver().getPageSource();
    }

    @Override
    public String takeFullPageScreenshot() throws Exception {
        return ((TakesScreenshot) this.getDriver()).getScreenshotAs(OutputType.BASE64);
    }

    @Override
    public String getAccessibilityTree() throws Exception {
        var driver = this.getDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return StringUtils.EMPTY;
        }
        String script = """
                return __captureAccessibilityTree();
                """;
        Object result = ((JavascriptExecutor) driver).executeScript(script);
        return result != null ? result.toString() : StringUtils.EMPTY;
    }
}
