package com.kms.katalon.core.model.internal;

import java.util.List;

import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.util.collections.Pair;

/**
 * @apiNote **INTERNAL USE ONLY.** Do not use this class in client code.
 */
public class WebUIPlatformExecutionSettings {
    
    public WebUIPlatformExecutionSettings() {
        super();
    }

    // Element timeout
    private int elementTimeoutInSeconds;

    // Self-healing feature
    private boolean enableSelfHealing;

    private List<String> excludeKeywords;

    private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder;

    public int getElementTimeoutInSeconds() {
        return elementTimeoutInSeconds;
    }

    public void setElementTimeoutInSeconds(int elementTimeoutInSeconds) {
        this.elementTimeoutInSeconds = elementTimeoutInSeconds;
    }

    public boolean isEnableSelfHealing() {
        return enableSelfHealing;
    }

    public void setEnableSelfHealing(boolean enableSelfHealing) {
        this.enableSelfHealing = enableSelfHealing;
    }

    public List<String> getExcludeKeywords() {
        return excludeKeywords;
    }

    public void setExcludeKeywords(List<String> excludeKeywords) {
        this.excludeKeywords = excludeKeywords;
    }
    
    public List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrder() {
        return this.methodsPriorityOrder;
    }

    public void setMethodsPriorityOrder(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) {
        this.methodsPriorityOrder = methodsPriorityOrder;
    }

    public static class Builder {
        
        private int elementTimeoutInSeconds;

        private boolean enableSelfHealing;
        
        private List<String> excludeKeywords;
        
        private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder;
        
        public Builder() {
        }

        public Builder elementTimeoutInSeconds(int elementTimeoutInSeconds) {
            this.elementTimeoutInSeconds = elementTimeoutInSeconds;
            return this;
        }

        public Builder enableSelfHealing(boolean enableSelfHealing) {
            this.enableSelfHealing = enableSelfHealing;
            return this;
        }

        public Builder setExcludeKeywords(List<String> excludeKeywords) {
            this.excludeKeywords = excludeKeywords;
            return this;
        }

        public Builder setMethodsPriorityOrder(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) {
            this.methodsPriorityOrder = methodsPriorityOrder;
            return this;
        }

        public WebUIPlatformExecutionSettings build() {
            WebUIPlatformExecutionSettings executionSetting = new WebUIPlatformExecutionSettings();
            executionSetting.setElementTimeoutInSeconds(elementTimeoutInSeconds);
            executionSetting.setEnableSelfHealing(enableSelfHealing);
            executionSetting.setExcludeKeywords(excludeKeywords);
            executionSetting.setMethodsPriorityOrder(methodsPriorityOrder);
            return executionSetting;
        }
    }
}
