package com.kms.katalon.core.webservice.keyword.builtin;

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.webservice.constants.StringConstants
import com.kms.katalon.core.webservice.keyword.internal.WebserviceAbstractKeyword
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.keyword.internal.KeywordMain
import groovy.transform.CompileStatic
import java.text.MessageFormat

@Action(value = "setHarFileGeneration")
public class SetHarFileGenerationKeyword extends WebserviceAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
         return super.getSupportLevel(params)
    }

    @Override
    public Object execute(Object... params) {
         boolean enable = (boolean) params[0]
         FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
         setHarFileGeneration(enable,flowControl)
    }

    @CompileStatic
    public void setHarFileGeneration(boolean enable, FailureHandling flowControl)throws StepFailedException{
         KeywordMain.runKeyword({
             RunConfiguration.getExecutionGeneralProperties().put(RunConfiguration.REQUEST_ENABLE_HAR_FILE_GENERATION, enable)
             logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SET_HAR_FILE_GENERATION, enable))
        },flowControl,StringConstants.KW_LOG_FAILED_SET_HAR_FILE_GENERATION)
    }
}
