/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.git.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.git.components.wizards.CustomPushBranchWizard;
import com.kms.katalon.composer.integration.git.handlers.AbstractGitProjectHandler;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.actions.PushActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class PushHandler
extends AbstractGitProjectHandler {
    private static final String PUSH_COMMAND_ID = "org.eclipse.egit.ui.team.Push";
    @Named(value="activeShell")
    private Shell shell;

    @Override
    public String getEgitCommandId() {
        return PUSH_COMMAND_ID;
    }

    @Override
    public AbstractHandler getHandler() {
        PushActionHandler handler = new PushActionHandler();
        handler.setSelection((ISelection)this.createIProjectSelection());
        return handler;
    }

    @Override
    public void execute() {
        try {
            Repository repository = this.getRepository();
            CustomPushBranchWizard wizard = null;
            Ref ref = this.getBranchRef(repository);
            if (ref != null) {
                wizard = new CustomPushBranchWizard(repository, ref);
            } else {
                ObjectId id = repository.resolve(repository.getFullBranch());
                wizard = new CustomPushBranchWizard(repository, id);
            }
            WizardDialog dlg = new WizardDialog(this.shell, (IWizard)wizard);
            dlg.open();
        }
        catch (IOException | URISyntaxException ex) {
            Activator.handleError((String)ex.getLocalizedMessage(), (Throwable)ex, (boolean)false);
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private Ref getBranchRef(Repository repository) {
        try {
            String fullBranch = repository.getFullBranch();
            if (fullBranch != null && fullBranch.startsWith("refs/heads/")) {
                return repository.exactRef(fullBranch);
            }
        }
        catch (IOException e) {
            Activator.handleError((String)e.getLocalizedMessage(), (Throwable)e, (boolean)false);
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }
}

