/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.preferences;

import io.cucumber.eclipse.java.Activator;
import io.cucumber.eclipse.java.properties.CucumberJavaBackendProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public record CucumberJavaPreferences(IPreferenceStore store, IEclipsePreferences node, boolean showHooks, List<String> glueFilter, List<String> plugins) {
    static final String PREF_USE_STEP_DEFINITIONS_FILTERS = "io.cucumber.eclipse.java.use_step_definitions_filters";
    static final String PREF_ACTIVE_FILTERS_LIST = "io.cucumber.eclipse.java.active_filters";
    static final String PREF_INACTIVE_FILTERS_LIST = "io.cucumber.eclipse.java.inactive_filters";
    static final String PREF_SHOW_HOOK_ANNOTATIONS = "io.cucumber.eclipse.java.show_hooks";

    public static CucumberJavaPreferences of() {
        return CucumberJavaPreferences.of(null);
    }

    public static CucumberJavaPreferences of(IResource resource) {
        CucumberJavaBackendProperties properties;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (resource != null && (properties = CucumberJavaBackendProperties.of(resource)).isEnabled()) {
            return new CucumberJavaPreferences(store, properties.node(), properties.isShowHooks(), properties.getGlueFilter().toList(), properties.getPlugins().toList());
        }
        boolean showHooks = store.getBoolean(PREF_SHOW_HOOK_ANNOTATIONS);
        String string = store.getString(PREF_ACTIVE_FILTERS_LIST);
        return new CucumberJavaPreferences(store, null, showHooks, CucumberJavaPreferences.parseList(string), List.of());
    }

    static List<String> parseList(String listString) {
        if (listString == null || listString.isBlank()) {
            return List.of();
        }
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    static String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static void setShowHooks(boolean showhooks) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        CucumberJavaPreferences.setShowHooks(store, showhooks);
    }

    protected static void setShowHooks(IPreferenceStore store, boolean showhooks) {
        store.setValue(PREF_SHOW_HOOK_ANNOTATIONS, showhooks);
    }
}

