/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.quickfix;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class StepGenerator {
    public static TextEdit createStepSnippet(String snippetText, IDocument targetDocument) throws IOException, CoreException {
        ASTParser parser = ASTParser.newParser((int)24);
        parser.setSource(targetDocument.get().toCharArray());
        CompilationUnit target = (CompilationUnit)parser.createAST(null);
        target.recordModifications();
        TypeDeclaration targetType = (TypeDeclaration)target.types().get(0);
        parser.setKind(4);
        parser.setSource(snippetText.toCharArray());
        TypeDeclaration fragmentContainer = (TypeDeclaration)parser.createAST(null);
        for (Object fragmentObject : fragmentContainer.bodyDeclarations()) {
            BodyDeclaration fragmentNode = (BodyDeclaration)fragmentObject;
            fragmentNode = (BodyDeclaration)ASTNode.copySubtree((AST)target.getAST(), (ASTNode)fragmentNode);
            List bodyDeclarations = targetType.bodyDeclarations();
            bodyDeclarations.add(StepGenerator.getInsertionPoint(targetType, fragmentNode), fragmentNode);
        }
        return target.rewrite(targetDocument, null);
    }

    private static int getInsertionPoint(TypeDeclaration source, BodyDeclaration fragment) {
        if (source.bodyDeclarations().isEmpty()) {
            return 0;
        }
        if (fragment.getNodeType() == 31) {
            int last = StepGenerator.getLastFragmentOfTypePosition(source, fragment.getNodeType(), fragment.getModifiers());
            if (last >= 0) {
                return last + 1;
            }
            int afterFields = StepGenerator.getLastFragmentOfTypePosition(source, 23);
            return afterFields >= 0 ? afterFields + 1 : 0;
        }
        return 0;
    }

    private static int getLastFragmentOfTypePosition(TypeDeclaration source, int nodeType) {
        return StepGenerator.getLastFragmentOfTypePosition(source, nodeType, -1);
    }

    private static int getLastFragmentOfTypePosition(TypeDeclaration source, int nodeType, int modifiers) {
        int i = source.bodyDeclarations().size() - 1;
        while (i >= 0) {
            BodyDeclaration bodyDecl = (BodyDeclaration)source.bodyDeclarations().get(i);
            if (bodyDecl.getNodeType() == nodeType && (modifiers == -1 || bodyDecl.getModifiers() == modifiers)) {
                return i;
            }
            --i;
        }
        return -1;
    }
}

