/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.runtime;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeatureParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.resource.Resource;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.java.Activator;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.launching.FileResource;
import io.cucumber.plugin.Plugin;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public final class CucumberRuntime
implements AutoCloseable {
    private static final FeatureParser FEATURE_PARSER = new FeatureParser(UUID::randomUUID);
    private List<Feature> features = new ArrayList<Feature>();
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private IJavaProject javaProject;
    private URLClassLoader classLoader;
    private RuntimeOptionsBuilder runtimeOptions;
    private UuidGenerator uuidGenerator;

    private CucumberRuntime(IJavaProject javaProject) throws CoreException {
        this.javaProject = javaProject;
        this.classLoader = JDTUtil.createClassloader(javaProject);
        this.runtimeOptions = new RuntimeOptionsBuilder().addDefaultGlueIfAbsent().setThreads(Runtime.getRuntime().availableProcessors()).setSnippetType(SnippetType.CAMELCASE).setMonochrome(true);
    }

    public static Optional<Feature> loadFeature(Resource resource) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(GherkinMessagesFeatureParser.class.getClassLoader());
            Optional optional = FEATURE_PARSER.parseResource(resource);
            return optional;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    @Override
    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            Activator.warn("can't close classlaoder for project " + this.javaProject.getElementName(), e);
        }
    }

    public RuntimeOptionsBuilder getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public void run(IProgressMonitor monitor) {
        this.run(monitor, null);
    }

    public void run(IProgressMonitor monitor, PrintStream stream) {
        RuntimeOptions options = this.runtimeOptions.build();
        PrintStream old = System.out;
        try {
            if (stream != null) {
                System.setOut(stream);
            }
            io.cucumber.core.runtime.Runtime runtime = io.cucumber.core.runtime.Runtime.builder().withRuntimeOptions(options).withClassLoader(() -> this.classLoader).withFeatureSupplier(() -> Collections.unmodifiableList(this.features)).withAdditionalPlugins((Plugin[])this.plugins.toArray(Plugin[]::new)).withEventBus((EventBus)(this.uuidGenerator == null ? null : new TimeServiceEventBus(Clock.systemUTC(), (Supplier)this.uuidGenerator))).build();
            runtime.run();
        }
        finally {
            if (stream != null) {
                System.setOut(old);
            }
        }
    }

    public void addFeature(IFile file) {
        CucumberRuntime.loadFeature(new FileResource(file)).ifPresent(this.features::add);
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
    }

    public Plugin addPluginFromClasspath(String clazz) {
        try {
            Class<?> c = this.classLoader.loadClass(clazz);
            Object instance = c.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (instance instanceof Plugin) {
                Plugin plugin = (Plugin)instance;
                this.addPlugin(plugin);
                return plugin;
            }
        }
        catch (Exception e) {
            ILog.get().error("Can't load plugin '" + clazz + "' from classpath", (Throwable)e);
        }
        return null;
    }

    public void addFeature(final GherkinEditorDocument document) {
        IResource resource = document.getResource();
        final URI uri = Objects.requireNonNullElseGet(resource.getLocationURI(), () -> resource.getRawLocationURI());
        CucumberRuntime.loadFeature(new Resource(){

            public URI getUri() {
                return uri;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(document.getDocument().get().getBytes(StandardCharsets.UTF_8));
            }
        }).ifPresent(this.features::add);
    }

    public static CucumberRuntime create(IJavaProject javaProject) throws CoreException {
        return new CucumberRuntime(javaProject);
    }

    public void setGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }
}

