/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest;

import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.integration.IntegratedType;
import com.kms.katalon.integration.qtest.QTestIntegrationAuthenticationManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestTestCase;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.exception.QTestUnauthorizedException;
import com.kms.katalon.integration.qtest.helper.QTestAPIRequestHelper;
import com.kms.katalon.integration.qtest.helper.QTestHttpRequestHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.services.project.ProjectServiceClient;
import org.qas.qtest.api.services.project.model.CreateModuleRequest;
import org.qas.qtest.api.services.project.model.Module;

public class QTestIntegrationFolderManager {
    private QTestIntegrationFolderManager() {
    }

    public static QTestModule getQTestModuleByFolderEntity(FolderEntity folderEntity) {
        if (folderEntity == null) {
            return null;
        }
        IntegratedEntity folderIntegratedEntity = folderEntity.getIntegratedEntity("qTest");
        QTestModule currentQTestTCFolder = null;
        if (folderIntegratedEntity != null) {
            currentQTestTCFolder = QTestIntegrationFolderManager.getQTestModuleByIntegratedEntity(folderIntegratedEntity);
        }
        return currentQTestTCFolder;
    }

    public static void deleteModuleOnQTest(QTestModule qTestModule, QTestProject qTestProject, IQTestCredential credential) throws QTestException, IOException {
        if (qTestProject == null) {
            throw new QTestUnauthorizedException("Cannot find qTest project. Please select a qTest project on qTest setting page.");
        }
        if (qTestModule.getParentId() == 0L) {
            return;
        }
        LinkedHashMap<String, Object> bodyProperties = new LinkedHashMap<String, Object>();
        int testCaseType = QTestModule.getType();
        bodyProperties.put("id", Integer.toString(testCaseType) + "-" + qTestModule.getId());
        bodyProperties.put("objId", qTestModule.getId());
        bodyProperties.put("parentId", qTestModule.getParentId());
        bodyProperties.put("type", testCaseType);
        String url = "/p/" + Long.toString(qTestProject.getId()) + "/portal/tree/delete";
        QTestIntegrationAuthenticationManager.authenticate(credential.getUsername(), credential.getPassword());
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("data", QTestHttpRequestHelper.createDataBody(bodyProperties, true));
        QTestHttpRequestHelper.sendPostRequest(credential, url, body);
    }

    public static QTestModule getQTestModuleByIntegratedEntity(IntegratedEntity integratedEntity) {
        if (integratedEntity.getType() != IntegratedType.FOLDER) {
            return null;
        }
        Map properties = integratedEntity.getProperties();
        if (properties == null) {
            return null;
        }
        String id = (String)properties.get("id");
        String name = (String)properties.get("name");
        String parentId = (String)properties.get("parentId");
        return new QTestModule(Long.parseLong(id), name, Long.parseLong(parentId));
    }

    public static IntegratedEntity getFolderIntegratedEntityByQTestModule(QTestModule qTestModule) {
        IntegratedEntity folderIntegratedEntity = new IntegratedEntity();
        folderIntegratedEntity.setProductName("qTest");
        folderIntegratedEntity.setType(IntegratedType.FOLDER);
        folderIntegratedEntity.getProperties().put("id", Long.toString(qTestModule.getId()));
        folderIntegratedEntity.getProperties().put("name", qTestModule.getName());
        folderIntegratedEntity.getProperties().put("parentId", Long.toString(qTestModule.getParentId()));
        return folderIntegratedEntity;
    }

    public static IntegratedEntity getFolderIntegratedEntityByQTestProject(QTestProject qTestProject) {
        IntegratedEntity folderIntegratedEntity = new IntegratedEntity();
        folderIntegratedEntity.setProductName("qTest");
        folderIntegratedEntity.setType(IntegratedType.FOLDER);
        folderIntegratedEntity.getProperties().put("id", Long.toString(qTestProject.getId()));
        folderIntegratedEntity.getProperties().put("name", qTestProject.getName());
        return folderIntegratedEntity;
    }

    public static QTestModule createNewQTestTCFolder(IQTestCredential credential, long projectId, long parentId, String name) throws QTestUnauthorizedException, QTestInvalidFormatException {
        Module moduleResult;
        String accessToken = credential.getToken().getAccessTokenHeader();
        if (!QTestIntegrationAuthenticationManager.validateToken(accessToken)) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        BasicQTestCredentials credentials = new BasicQTestCredentials(accessToken);
        ProjectServiceClient projectServiceClient = new ProjectServiceClient((QTestCredentials)credentials);
        projectServiceClient.setEndpoint(credential.getServerUrl());
        Module module = new Module().withName(name);
        CreateModuleRequest createTestCaseFolderRequest = new CreateModuleRequest().withProjectId(Long.valueOf(projectId)).withModule(module);
        if (parentId > 0L) {
            createTestCaseFolderRequest.withParentId(Long.valueOf(parentId));
        }
        if ((moduleResult = projectServiceClient.createModule(createTestCaseFolderRequest)) != null) {
            QTestModule qTestTestCase = new QTestModule(moduleResult.getId(), name, moduleResult.getParentId());
            qTestTestCase.setGid(moduleResult.getPid());
            return qTestTestCase;
        }
        return null;
    }

    public static QTestModule getModuleRoot(IQTestCredential credential, QTestProject qTestProject) throws QTestException, IOException {
        return new QTestModule(0L, qTestProject.getName(), 0L);
    }

    public static QTestModule updateModuleViaAPI(IQTestCredential credential, long projectId, QTestModule qTestParentModule) throws QTestException {
        String serverUrl = credential.getServerUrl();
        if (!QTestIntegrationAuthenticationManager.validateToken(credential.getToken().getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        Object parentIdPrefix = "";
        if (qTestParentModule.getId() > 0L) {
            parentIdPrefix = "parentId=" + Long.toString(qTestParentModule.getId()) + "&";
        }
        String url = serverUrl + "/api/v3/projects/" + Long.toString(projectId) + "/modules?" + (String)parentIdPrefix + "expand=descendants";
        String result = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            if (result != null && !result.isEmpty()) {
                QTestIntegrationFolderManager.updateChildrenForModule(new JsonArray(result), qTestParentModule);
            }
            return qTestParentModule;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    private static List<QTestModule> getModules(IQTestCredential credential, QTestModule qTestParentModule, long projectId) throws QTestException {
        String serverUrl = credential.getServerUrl();
        if (!QTestIntegrationAuthenticationManager.validateToken(credential.getToken().getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        Object parentIdPrefix = "";
        if (qTestParentModule.getId() > 0L) {
            parentIdPrefix = "parentId=" + Long.toString(qTestParentModule.getId()) + "&";
        }
        String url = serverUrl + "/api/v3/projects/" + Long.toString(projectId) + "/modules?" + (String)parentIdPrefix + "expand=descendants";
        String result = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            ArrayList<QTestModule> modules = new ArrayList<QTestModule>();
            JsonArray childrenJsonArray = new JsonArray(result);
            int index = 0;
            while (index < childrenJsonArray.length()) {
                JsonObject childJsonObject = childrenJsonArray.getJsonObject(index);
                QTestModule qTestCase = new QTestModule(childJsonObject.getLong("id"), childJsonObject.getString("name"), qTestParentModule.getId());
                modules.add(qTestCase);
                ++index;
            }
            return modules;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    private static List<QTestTestCase> getTestCases(IQTestCredential credential, QTestModule qTestParentModule, long projectId) throws QTestException {
        String serverUrl = credential.getServerUrl();
        if (!QTestIntegrationAuthenticationManager.validateToken(credential.getToken().getAccessTokenHeader())) {
            throw new QTestUnauthorizedException("Token is not valid");
        }
        Object parentIdPrefix = "";
        if (qTestParentModule.getId() <= 0L) {
            return null;
        }
        parentIdPrefix = "parentId=" + Long.toString(qTestParentModule.getId()) + "&";
        String url = serverUrl + "/api/v3/projects/" + Long.toString(projectId) + "/test-cases?" + (String)parentIdPrefix + "expand=descendants";
        String result = QTestAPIRequestHelper.sendGetRequestViaAPI(url, credential.getToken());
        try {
            ArrayList<QTestTestCase> testCases = new ArrayList<QTestTestCase>();
            JsonArray childrenJsonArray = new JsonArray(result);
            int index = 0;
            while (index < childrenJsonArray.length()) {
                JsonObject childJsonObject = childrenJsonArray.getJsonObject(index);
                QTestTestCase qTestCase = new QTestTestCase(childJsonObject.getLong("id"), childJsonObject.getString("name"), qTestParentModule.getId(), childJsonObject.getString("pid"));
                qTestCase.setVersion(childJsonObject.getString("version"));
                testCases.add(qTestCase);
                ++index;
            }
            return testCases;
        }
        catch (JsonException jsonException) {
            throw QTestInvalidFormatException.createInvalidJsonFormatException(result);
        }
    }

    private static void updateChildrenForModule(JsonArray jsonArray, QTestModule qTestParentModule) throws JsonException {
        int index = 0;
        while (index < jsonArray.length()) {
            JsonObject moduleJsonObject = jsonArray.getJsonObject(index);
            QTestModule qTestChildModule = new QTestModule(moduleJsonObject.getLong("id"), moduleJsonObject.getString("name"), qTestParentModule.getId());
            qTestParentModule.getChildModules().add(qTestChildModule);
            String childrenField = "children";
            if (moduleJsonObject.has(childrenField)) {
                QTestIntegrationFolderManager.updateChildrenForModule(moduleJsonObject.getJsonArray(childrenField), qTestChildModule);
            }
            ++index;
        }
    }

    public static QTestModule updateModule(IQTestCredential credential, long projectId, QTestModule qTestParentModule, boolean updateChildren) throws QTestException, IOException {
        qTestParentModule.setChildTestCases(QTestIntegrationFolderManager.getTestCases(credential, qTestParentModule, projectId));
        qTestParentModule.setChildModules(QTestIntegrationFolderManager.getModules(credential, qTestParentModule, projectId));
        if (updateChildren) {
            for (QTestModule qTestChildModule : qTestParentModule.getChildModules()) {
                QTestIntegrationFolderManager.updateModule(credential, projectId, qTestChildModule, updateChildren);
            }
        }
        return qTestParentModule;
    }
}

