/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.utils;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.FileUtil;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AndroidSdkUtil {
    private static String SDK_ROOT = GlobalStringConstants.KATALON_TOOLS_DIR;

    public static File getSdkFolder() {
        File sdkFolder;
        String androidHome = GlobalStringConstants.ANDROID_HOME_ENV;
        if (StringUtils.isNotBlank((CharSequence)androidHome) && (sdkFolder = new File(androidHome)).exists()) {
            return sdkFolder;
        }
        return new File(SDK_ROOT, "android_sdk");
    }

    public static File getPlatformToolsFolder() {
        File sdkFolder = AndroidSdkUtil.getSdkFolder();
        File existingPlatformToolsFolder = FileUtil.findFolderByName((String)sdkFolder.getAbsolutePath(), (String)"platform-tools.*");
        return existingPlatformToolsFolder != null ? existingPlatformToolsFolder : new File(sdkFolder, "platform-tools");
    }

    public static File getBuildToolsFolder() {
        File sdkFolder = AndroidSdkUtil.getSdkFolder();
        File existingBuildToolsFolder = FileUtil.findFolderByName((String)sdkFolder.getAbsolutePath(), (String)"build-tools.*");
        return existingBuildToolsFolder != null ? existingBuildToolsFolder : new File(sdkFolder, "build-tools");
    }

    public static File getToolsFolder() {
        File sdkFolder = AndroidSdkUtil.getSdkFolder();
        File existingToolsFolder = FileUtil.findFolderByName((String)sdkFolder.getAbsolutePath(), (String)"tools.*");
        return existingToolsFolder != null ? existingToolsFolder : new File(sdkFolder, "tools");
    }

    public static boolean checkSdkExists() {
        File sdkFolder = AndroidSdkUtil.getSdkFolder();
        if (!sdkFolder.exists() || !sdkFolder.isDirectory()) {
            return false;
        }
        File platformToolsFolder = AndroidSdkUtil.getPlatformToolsFolder();
        if (!platformToolsFolder.exists() || !platformToolsFolder.isDirectory() || ArrayUtils.isEmpty((Object[])platformToolsFolder.listFiles())) {
            return false;
        }
        File buildToolsFolder = AndroidSdkUtil.getBuildToolsFolder();
        return buildToolsFolder.exists() && buildToolsFolder.isDirectory() && !ArrayUtils.isEmpty((Object[])buildToolsFolder.listFiles());
    }
}

