/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashSet;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ErrorCollecting;

public abstract class ClassCodeVisitorSupport
extends CodeVisitorSupport
implements ErrorCollecting,
GroovyClassVisitor {
    public static final String ORIGINAL_EXPRESSION = "OriginalExpression";

    public void visitClass(ClassNode node) {
        this.visitAnnotations(node);
        this.visitPackage(node.getPackage());
        this.visitImports(node.getModule());
        node.visitContents(this);
        this.visitObjectInitializerStatements(node);
    }

    public void visitAnnotations(AnnotatedNode node) {
        this.visitAnnotations(node.getAnnotations());
    }

    protected void visitAnnotations(Iterable<AnnotationNode> nodes) {
        HashSet aliases = null;
        for (AnnotationNode node : nodes) {
            if (node.isBuiltIn()) continue;
            this.visitAnnotation(node);
            Iterable original = (Iterable)node.getNodeMetaData((Object)"AnnotationCollector");
            if (original == null) continue;
            if (aliases == null) {
                aliases = new HashSet();
            }
            original.forEach(aliases::add);
        }
        if (aliases != null) {
            this.visitAnnotations(aliases);
        }
    }

    protected void visitAnnotation(AnnotationNode node) {
        for (Expression expr : node.getMembers().values()) {
            expr.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    public void visitPackage(PackageNode node) {
        if (node != null) {
            this.visitAnnotations((AnnotatedNode)node);
            node.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    public void visitImports(ModuleNode node) {
        if (node != null) {
            for (ImportNode importNode : node.getImports()) {
                this.visitAnnotations(importNode);
                importNode.visit((GroovyCodeVisitor)((Object)this));
            }
            for (ImportNode importStarNode : node.getStarImports()) {
                this.visitAnnotations(importStarNode);
                importStarNode.visit((GroovyCodeVisitor)((Object)this));
            }
            for (ImportNode importStaticNode : node.getStaticImports().values()) {
                this.visitAnnotations(importStaticNode);
                importStaticNode.visit((GroovyCodeVisitor)((Object)this));
            }
            for (ImportNode importStaticStarNode : node.getStaticStarImports().values()) {
                this.visitAnnotations(importStaticStarNode);
                importStaticStarNode.visit((GroovyCodeVisitor)((Object)this));
            }
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitConstructorOrMethod((MethodNode)node, true);
    }

    public void visitMethod(MethodNode node) {
        this.visitConstructorOrMethod(node, false);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.visitAnnotations(node);
        this.visitClassCodeContainer(node.getCode());
        Parameter[] parameterArray = node.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            this.visitAnnotations(param);
            ++n2;
        }
    }

    public void visitField(FieldNode node) {
        this.visitAnnotations((AnnotatedNode)node);
        Expression init = node.getInitialExpression();
        if (init != null) {
            init.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    public void visitProperty(PropertyNode node) {
        this.visitAnnotations((AnnotatedNode)node);
        Statement statement = node.getGetterBlock();
        this.visitClassCodeContainer(statement);
        statement = node.getSetterBlock();
        this.visitClassCodeContainer(statement);
        Expression init = node.getInitialExpression();
        if (init != null) {
            init.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    protected void visitClassCodeContainer(Statement code) {
        if (code != null) {
            code.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    protected void visitObjectInitializerStatements(ClassNode node) {
        for (Statement statement : node.getObjectInitializerStatements()) {
            statement.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this.visitAnnotations((AnnotatedNode)expression);
        super.visitDeclarationExpression(expression);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        Expression original = (Expression)expression.getNodeMetaData(ORIGINAL_EXPRESSION);
        if (original != null) {
            original.visit((GroovyCodeVisitor)((Object)this));
        }
    }

    public static final Expression getNonInlinedExpression(Expression expression) {
        Expression original = (Expression)expression.getNodeMetaData((Object)ORIGINAL_EXPRESSION);
        return original != null ? original : expression;
    }

    public void visitAssertStatement(AssertStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitAssertStatement(statement);
    }

    public void visitBlockStatement(BlockStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitBlockStatement(statement);
    }

    public void visitBreakStatement(BreakStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitBreakStatement(statement);
    }

    public void visitCaseStatement(CaseStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitCaseStatement(statement);
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitCatchStatement(statement);
    }

    public void visitContinueStatement(ContinueStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitContinueStatement(statement);
    }

    public void visitDoWhileLoop(DoWhileStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitDoWhileLoop(statement);
    }

    public void visitExpressionStatement(ExpressionStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitExpressionStatement(statement);
    }

    public void visitForLoop(ForStatement statement) {
        this.visitStatement(statement);
        super.visitForLoop(statement);
    }

    public void visitIfElse(IfStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitIfElse(statement);
    }

    public void visitReturnStatement(ReturnStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitReturnStatement(statement);
    }

    public void visitSwitch(SwitchStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitSwitch(statement);
    }

    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitSynchronizedStatement(statement);
    }

    public void visitThrowStatement(ThrowStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitThrowStatement(statement);
    }

    public void visitTryCatchFinally(TryCatchStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitTryCatchFinally(statement);
    }

    public void visitWhileLoop(WhileStatement statement) {
        this.visitStatement((Statement)statement);
        super.visitWhileLoop(statement);
    }

    protected void visitStatement(Statement statement) {
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }

    public void addError(String error, ASTNode node) {
        int end;
        int start;
        if (node instanceof AnnotatedNode && ((AnnotatedNode)node).getNameEnd() > 0) {
            start = ((AnnotatedNode)node).getNameStart();
            end = ((AnnotatedNode)node).getNameEnd();
            Integer offset = (Integer)node.getNodeMetaData("rparen.offset");
            if (offset != null) {
                end = offset;
            }
        } else {
            if (node instanceof DeclarationExpression) {
                this.addError(error, (ASTNode)((DeclarationExpression)node).getLeftExpression());
                return;
            }
            if (node instanceof AnnotationNode) {
                start = node.getStart();
                end = ((AnnotationNode)node).getClassNode().getEnd() - 1;
            } else {
                start = node.getStart();
                end = node.getEnd() - 1;
            }
        }
        SourceUnit source = this.getSourceUnit();
        source.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage((SyntaxException)new PreciseSyntaxException(String.valueOf(error) + '\n', node.getLineNumber(), node.getColumnNumber(), start, end), source));
    }
}

