/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.plugin.util;

import com.kms.katalon.activation.plugin.models.KatalonStoreToken;
import com.kms.katalon.activation.plugin.store.PluginPreferenceStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class KStoreTokenService {
    private static final int TOKEN_VALID_HOURS = 23;
    private static KStoreTokenService instance;
    private PluginPreferenceStore store = new PluginPreferenceStore();

    public static KStoreTokenService getInstance() {
        if (instance == null) {
            instance = new KStoreTokenService();
        }
        return instance;
    }

    private KStoreTokenService() {
    }

    public KatalonStoreToken createNewToken(String tokenString) throws IOException, GeneralSecurityException {
        KatalonStoreToken token = new KatalonStoreToken();
        Date currentDate = new Date();
        token.setToken(tokenString);
        token.setExpirationDate(DateUtils.addHours((Date)currentDate, (int)23));
        this.store.setToken(token);
        return token;
    }

    public KatalonStoreToken getToken() throws GeneralSecurityException, IOException {
        return this.store.getToken();
    }

    public boolean isTokenExpired(KatalonStoreToken token) {
        Date currentDate = new Date();
        return currentDate.after(token.getExpirationDate());
    }
}

