/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.dialog;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.execution.logging.RecordingOutputStreamHandler;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RecordedLogView {
    private StyledText txtVerificationLog;
    private Label lblVerificationResultStatus;
    private Composite resultStatusComposite;
    private EventServiceAdapter eventHandler;

    public Composite createLogsView(Composite parent) {
        Composite logView = new Composite(parent, 0);
        logView.setLayout((Layout)new GridLayout());
        this.resultStatusComposite = new Composite(logView, 0);
        this.resultStatusComposite.setLayoutData((Object)new GridData(768));
        GridLayout glResultStatus = new GridLayout(2, false);
        glResultStatus.marginWidth = 0;
        glResultStatus.marginHeight = 0;
        this.resultStatusComposite.setLayout((Layout)glResultStatus);
        Label lblVerificationResult = new Label(this.resultStatusComposite, 0);
        lblVerificationResult.setText("Status");
        this.lblVerificationResultStatus = new Label(this.resultStatusComposite, 0);
        this.lblVerificationResultStatus.setForeground(ColorUtil.getTextWhiteColor());
        this.txtVerificationLog = new StyledText(logView, 586);
        this.txtVerificationLog.setLayoutData((Object)new GridData(4, 4, true, true));
        this.txtVerificationLog.setFont(JFaceResources.getTextFont());
        this.txtVerificationLog.setBackground(ColorUtil.getWhiteBackgroundColor());
        this.registerEventListeners();
        return logView;
    }

    private void registerEventListeners() {
        this.eventHandler = new EventServiceAdapter(){

            public void handleEvent(Event event) {
                switch (event.getTopic()) {
                    case "WEBUI_VERIFICATION/LOG_UPDATED": {
                        int lineCount;
                        RecordingOutputStreamHandler.RecordedOutputLine output = (RecordingOutputStreamHandler.RecordedOutputLine)this.getObject(event);
                        int start = RecordedLogView.this.txtVerificationLog.getCharCount();
                        String text = output.getText();
                        RecordedLogView.this.txtVerificationLog.append(text + "\n");
                        if (output.getType() == RecordingOutputStreamHandler.OutputType.ERROR) {
                            StyleRange errorStyleRange = new StyleRange();
                            errorStyleRange.foreground = ColorUtil.getTextErrorColor();
                            errorStyleRange.start = start;
                            errorStyleRange.length = text.length();
                            RecordedLogView.this.txtVerificationLog.setStyleRange(errorStyleRange);
                        }
                        if ((lineCount = RecordedLogView.this.txtVerificationLog.getLineCount()) >= 1) {
                            RecordedLogView.this.txtVerificationLog.setTopIndex(lineCount - 1);
                        }
                        return;
                    }
                    case "WEBUI_VERIFICATION/EXECUTION_FINISHED": {
                        RecordedLogView.this.setVerificationResultStatus((TestStatus.TestStatusValue)this.getObject(event));
                        return;
                    }
                    case "WEBUI_VERIFICATION/START_EXECUTION": {
                        RecordedLogView.this.txtVerificationLog.getDisplay().asyncExec(() -> {
                            RecordedLogView.this.lblVerificationResultStatus.setText("RUNNING");
                            RecordedLogView.this.lblVerificationResultStatus.setForeground(ColorUtil.getBlackBackgroundColor());
                            RecordedLogView.this.lblVerificationResultStatus.setBackground(ColorUtil.getRunningLogBackgroundColor());
                            RecordedLogView.this.resultStatusComposite.layout(true, true);
                            RecordedLogView.this.txtVerificationLog.setText("");
                            RecordedLogView.this.txtVerificationLog.setStyleRanges(new StyleRange[0]);
                        });
                        return;
                    }
                    case "WEBUI_VERIFICATION/STOP_EXECUTION": {
                        RecordedLogView.this.setVerificationResultStatus(TestStatus.TestStatusValue.INCOMPLETE);
                        return;
                    }
                }
            }
        };
        final IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.subscribe("WEBUI_VERIFICATION/LOG_UPDATED", (EventHandler)this.eventHandler);
        eventBroker.subscribe("WEBUI_VERIFICATION/EXECUTION_FINISHED", (EventHandler)this.eventHandler);
        eventBroker.subscribe("WEBUI_VERIFICATION/START_EXECUTION", (EventHandler)this.eventHandler);
        eventBroker.subscribe("WEBUI_VERIFICATION/STOP_EXECUTION", (EventHandler)this.eventHandler);
        this.resultStatusComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                eventBroker.unsubscribe((EventHandler)RecordedLogView.this.eventHandler);
            }
        });
    }

    private void setVerificationResultStatus(TestStatus.TestStatusValue value) {
        this.lblVerificationResultStatus.setText(value.toString());
        this.lblVerificationResultStatus.setForeground(ColorUtil.getTextWhiteColor());
        this.lblVerificationResultStatus.setBackground(this.getBackgroundColorForVerificationResultStatus(value));
        this.resultStatusComposite.layout(true, true);
    }

    private Color getBackgroundColorForVerificationResultStatus(TestStatus.TestStatusValue value) {
        if (TestStatus.TestStatusValue.PASSED.equals((Object)value)) {
            return ColorUtil.getPassedLogBackgroundColor();
        }
        if (TestStatus.TestStatusValue.WARNING.equals((Object)value)) {
            return ColorUtil.getWarningLogBackgroundColor();
        }
        if (TestStatus.TestStatusValue.ERROR.equals((Object)value) || TestStatus.TestStatusValue.FAILED.equals((Object)value)) {
            return ColorUtil.getErrorLogBackgroundColor();
        }
        if (TestStatus.TestStatusValue.INCOMPLETE.equals((Object)value)) {
            return ColorUtil.getIncompleteLogColor();
        }
        return ColorUtil.getDefaultBackgroundColor();
    }
}

