/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.dialogs;

import com.kms.katalon.composer.components.impl.dialogs.AbstractEntityDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.dal.exception.InvalidNameException;
import com.kms.katalon.entity.folder.FolderEntity;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.swt.widgets.Shell;

public abstract class CommonAbstractKeywordDialog
extends AbstractEntityDialog {
    protected static final String NAME_EXISTED = com.kms.katalon.composer.components.impl.constants.StringConstants.DIA_NAME_EXISTED;

    public CommonAbstractKeywordDialog(Shell parentShell, FolderEntity parentFolder) {
        super(parentShell, parentFolder);
    }

    public void updateStatus() {
        super.getButton(0).setEnabled(this.isValidEntityName());
    }

    private boolean isValidEntityName() {
        try {
            this.validateEntityName(this.getName());
            this.setErrorMessage(null);
            return true;
        }
        catch (InvalidNameException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    public abstract void validateEntityName(String var1) throws Exception;

    protected void validatePackageName(String name, IPackageFragment pkg) throws Exception {
        IStatus status = JavaConventionsUtil.validatePackageName((String)name, (IJavaElement)pkg);
        if (status.isOK()) {
            this.validateUnsupportedCharacters(name, StringConstants.DIA_MSG_INVALID_PACKAGE_NAME);
            return;
        }
        String errorMsg = status.getMessage();
        if (StringUtils.endsWith((String)errorMsg, (String)StringConstants.DIA_MSG_INVALID_JAVA_IDENTIFIER)) {
            throw new InvalidNameException(StringConstants.DIA_MSG_INVALID_PACKAGE_NAME);
        }
        throw new InvalidNameException(errorMsg);
    }

    protected void validateKeywordName(String name, IPackageFragment parentPackage) throws Exception {
        IStatus status;
        GroovyCompilationUnit cu;
        name = (String)name + ".groovy";
        if (parentPackage.exists()) {
            ICompilationUnit[] iCompilationUnitArray = parentPackage.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                cu = iCompilationUnitArray[n2];
                if (StringUtils.equalsIgnoreCase((String)name, (String)cu.getElementName())) {
                    throw new InvalidNameException(NAME_EXISTED);
                }
                ++n2;
            }
        }
        if ((status = JavaConventionsUtil.validateCompilationUnitName((String)name, (IJavaElement)(cu = (GroovyCompilationUnit)parentPackage.getCompilationUnit((String)name)))).isOK()) {
            this.validateUnsupportedCharacters((String)name, StringConstants.DIA_MSG_INVALID_KEYWORD_NAME);
            if (StringUtils.isAllLowerCase((String)((String)name).substring(0, 1))) {
                this.setMessage(StringConstants.DIA_WARN_KEYWORD_START_WITH_LOWERCASE, 2);
            }
            return;
        }
        String errorMsg = status.getMessage();
        if (StringUtils.endsWith((String)errorMsg, (String)StringConstants.DIA_MSG_INVALID_JAVA_IDENTIFIER)) {
            throw new InvalidNameException(StringConstants.DIA_MSG_INVALID_KEYWORD_NAME);
        }
        throw new InvalidNameException(errorMsg.replaceAll(" Java", "").replaceAll("(?i)type", StringConstants.KEYWORD));
    }

    private void validateUnsupportedCharacters(String entityName, String customMessage) throws Exception {
        block2: {
            try {
                EntityNameController.getInstance().validateName(entityName);
            }
            catch (InvalidNameException e) {
                String string = customMessage = customMessage != null ? customMessage : e.getMessage();
                if (!StringUtils.startsWith((String)e.getMessage(), (String)"Invalid name! A file name")) break block2;
                throw new InvalidNameException(customMessage);
            }
        }
    }
}

