/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.dialogs;

import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.CommonAbstractKeywordDialog;
import com.kms.katalon.dal.exception.InvalidNameException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.swt.widgets.Shell;

public class NewRenamePackageDialog
extends CommonAbstractKeywordDialog {
    private IPackageFragmentRoot rootPackage;
    private String originalName;

    public NewRenamePackageDialog(Shell parentShell, IPackageFragmentRoot rootPackage, boolean isNew) {
        super(parentShell, null);
        this.setDialogTitle(StringConstants.DIA_TITLE_PACKAGE);
        if (isNew) {
            this.setDialogMsg(StringConstants.DIA_MSG_NEW_PACKAGE);
        } else {
            this.setWindowTitle(StringConstants.DIA_TITLE_RENAME);
            this.setDialogMsg(StringConstants.DIA_MSG_RENAME_PACKAGE);
        }
        this.setTitleImage(JavaPluginImages.DESC_WIZBAN_NEWPACK.createImage());
        this.setFileEntity(false);
        this.rootPackage = rootPackage;
    }

    public NewRenamePackageDialog(Shell parentShell, IPackageFragmentRoot rootPackage, boolean isNew, String originalName) {
        this(parentShell, rootPackage, isNew);
        this.originalName = originalName;
        this.setName(originalName);
    }

    @Override
    public void validateEntityName(String entityName) throws Exception {
        if (entityName.equals(this.originalName)) {
            throw new InvalidNameException(NAME_EXISTED);
        }
        IPackageFragment pkg = this.rootPackage.getPackageFragment(entityName);
        if (pkg.exists()) {
            throw new InvalidNameException(NAME_EXISTED);
        }
        this.validatePackageName(entityName, pkg);
    }
}

