/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DeleteKeywordAndPackageHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/DELETE_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (object != null && (object instanceof KeywordTreeEntity || object instanceof PackageTreeEntity)) {
                    DeleteKeywordAndPackageHandler.this.excute((ITreeEntity)object);
                }
            }
        });
    }

    private void excute(ITreeEntity treeEntity) {
        block11: {
            try {
                if (treeEntity.getObject() == null || !(treeEntity.getObject() instanceof ICompilationUnit) && !(treeEntity.getObject() instanceof IPackageFragment)) break block11;
                try {
                    if (this.partService != null && !this.partService.saveAll(true)) {
                        return;
                    }
                }
                catch (IllegalStateException illegalStateException) {}
                if (treeEntity.getObject() instanceof IPackageFragment) {
                    Object[] objectArray = treeEntity.getChildren();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        this.excute((ITreeEntity)child);
                        ++n2;
                    }
                    IPackageFragment packageFragment = (IPackageFragment)treeEntity.getObject();
                    String parentPath = packageFragment.getParent().getElementName() + "/";
                    String packageName = packageFragment.getElementName().isEmpty() ? StringConstants.DEFAULT_PACKAGE_NAME : packageFragment.getElementName();
                    this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)(parentPath + packageName));
                    packageFragment.delete(true, null);
                } else if (treeEntity.getObject() instanceof ICompilationUnit) {
                    ICompilationUnit file = (ICompilationUnit)treeEntity.getObject();
                    IFile iFile = (IFile)file.getResource();
                    KeywordController.getInstance().removeMethodNodesCustomKeywordFile(iFile, ProjectController.getInstance().getCurrentProject());
                    if (file.exists()) {
                        file.getResource().refreshLocal(0, null);
                        if (file.isWorkingCopy()) {
                            file = file.getPrimary();
                        }
                        file.delete(true, null);
                    }
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_DELETE_KEYWORD);
            }
        }
    }
}

