/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.keyword.handlers.ImportFolderHandler;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Display;

public class ImportGitFinishHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("GIT/KEYWORD_CLONE_FINISHED", event -> {
            Thread importKeywordsThread = new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    UISynchronizeService.syncExec(() -> {
                        try {
                            String tempDir = ProjectController.getInstance().getTempDir();
                            File gitTmpDir = new File(tempDir, "git_tmp");
                            ImportFolderHandler importHandler = new ImportFolderHandler();
                            importHandler.copyFilesToKeywordsDirectory(Display.getCurrent().getActiveShell(), gitTmpDir, event.getProperty("commitId").toString(), event.getProperty("repoUrl").toString());
                            if (gitTmpDir.exists()) {
                                FileUtils.deleteDirectory((File)gitTmpDir);
                            }
                            FolderTreeEntity keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
                            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
                            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordRootFolder);
                        }
                        catch (Exception e) {
                            this.handleException(e);
                        }
                    });
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            });
            importKeywordsThread.start();
        });
    }

    private void handleException(Exception e) {
        LoggerSingleton.logError((Throwable)e);
        MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to refresh this keyword", (String)e.getMessage());
    }
}

