/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.composer.keyword.dialogs.NewRenamePackageDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewPackageHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity selectedTreeEntity = null;
            ITreeEntity parentTreeEntity = null;
            IPackageFragment packageFragment = null;
            IPackageFragmentRoot packageRoot = null;
            if (selectedObjects[0] instanceof ITreeEntity) {
                selectedTreeEntity = (ITreeEntity)selectedObjects[0];
            }
            if (selectedTreeEntity != null) {
                if (selectedTreeEntity instanceof FolderTreeEntity) {
                    FolderEntity folder = (FolderEntity)selectedTreeEntity.getObject();
                    parentTreeEntity = selectedTreeEntity;
                    IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject());
                    packageRoot = JavaCore.create((IProject)groovyProject).getPackageFragmentRoot((IResource)groovyProject.getFolder(folder.getRelativePath()));
                } else if (selectedTreeEntity instanceof KeywordTreeEntity) {
                    if (selectedTreeEntity.getParent() != null && selectedTreeEntity.getParent() instanceof PackageTreeEntity) {
                        packageFragment = (IPackageFragment)((PackageTreeEntity)selectedTreeEntity.getParent()).getObject();
                        parentTreeEntity = ((PackageTreeEntity)selectedTreeEntity.getParent()).getParent();
                        packageRoot = (IPackageFragmentRoot)packageFragment.getParent();
                    }
                } else if (selectedTreeEntity instanceof PackageTreeEntity) {
                    packageFragment = (IPackageFragment)((PackageTreeEntity)selectedTreeEntity).getObject();
                    parentTreeEntity = selectedTreeEntity.getParent();
                    packageRoot = (IPackageFragmentRoot)packageFragment.getParent();
                }
            }
            if (packageRoot != null) {
                NewRenamePackageDialog dialog = new NewRenamePackageDialog(parentShell, packageRoot, true);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    if (dialog.getName().length() > 255) {
                        MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(StringConstants.HAND_ERROR_MSG_EXCEED_PKG_NAME_LENGTH, dialog.getName().length(), 255));
                        return;
                    }
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    IPackageFragment newPackageFragment = packageRoot.createPackageFragment(dialog.getName(), true, (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    Trackings.trackCreatingObject((String)"package", (Object[])new Object[0]);
                    this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
                    ICompilationUnit[] iCompilationUnitArray = newPackageFragment.getCompilationUnits();
                    int n = iCompilationUnitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompilationUnit compicationUnit = iCompilationUnitArray[n2];
                        compicationUnit.discardWorkingCopy();
                        ++n2;
                    }
                    this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)new PackageTreeEntity(newPackageFragment, parentTreeEntity));
                }
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_PACKAGE);
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (ArrayUtils.isNotEmpty((Object[])selectedObjects) && selectedObjects[0] instanceof ITreeEntity) {
            ITreeEntity parentTreeEntity = (ITreeEntity)selectedObjects[0];
            if (parentTreeEntity instanceof FolderTreeEntity) {
                FolderEntity parentFolder = (FolderEntity)parentTreeEntity.getObject();
                if (parentFolder.getFolderType() == FolderEntity.FolderType.KEYWORD) {
                    return parentTreeEntity;
                }
                if (FolderController.getInstance().isSourceFolder(ProjectController.getInstance().getCurrentProject(), parentFolder)) {
                    return parentTreeEntity;
                }
            } else if (parentTreeEntity instanceof KeywordTreeEntity || parentTreeEntity instanceof PackageTreeEntity) {
                return parentTreeEntity;
            }
        }
        return null;
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="PACKAGE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }
}

