/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jdt.core.ICompilationUnit;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshKeywordHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    Object selectedObject = event.getProperty("org.eclipse.e4.data");
                    if (selectedObject != null && selectedObject instanceof KeywordTreeEntity) {
                        KeywordTreeEntity keywordTreeEntity = (KeywordTreeEntity)selectedObject;
                        IFile keywordFile = (IFile)((ICompilationUnit)keywordTreeEntity.getObject()).getResource();
                        keywordFile.refreshLocal(0, null);
                        if (keywordFile != null && keywordFile.exists()) {
                            RefreshKeywordHandler.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordTreeEntity);
                            KeywordController.getInstance().parseCustomKeywordFile(keywordFile, ProjectController.getInstance().getCurrentProject());
                        } else {
                            RefreshKeywordHandler.this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordTreeEntity.getParent());
                        }
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to refresh this keyword", (String)e.getMessage());
                }
            }
        });
    }
}

