/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.refactoring;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.PartServiceSingleton;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class KeywordClassRenamingParticipant
extends RenameParticipant {
    private ICompilationUnit keywordClass;

    protected boolean initialize(Object element) {
        ICompilationUnit unit;
        String filePath;
        if (element instanceof ICompilationUnit && GroovyUtil.isKeywordFile((String)(filePath = (unit = (ICompilationUnit)element).getResource().getRawLocation().toString()), (ProjectEntity)KeywordClassRenamingParticipant.getProjectEntity())) {
            this.keywordClass = unit;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Rename Keyword Class";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RenameArguments arguments = this.getArguments();
        String packageName = this.keywordClass.getParent().getElementName();
        String oldClassQualifier = ((String)(packageName.isEmpty() ? this.keywordClass.getElementName() : packageName + "." + this.keywordClass.getElementName())).replace(".groovy", "");
        String newClassQualifier = ((String)(packageName.isEmpty() ? arguments.getNewName() : packageName + "." + arguments.getNewName())).replace(".groovy", "");
        KeywordClassRenamingParticipant.updateReferences(oldClassQualifier, newClassQualifier);
        try {
            EventBrokerSingleton.getInstance().getEventBroker().send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(KeywordClassRenamingParticipant.getProjectEntity()), null));
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return null;
    }

    public static void updateReferences(String oldClassQualifier, String newClassQualifier) {
        String oldScript = "CustomKeywords.'" + oldClassQualifier + ".";
        String newScript = "CustomKeywords.'" + newClassQualifier + ".";
        try {
            GroovyRefreshUtil.updateScriptReferencesInTestCaseAndCustomScripts((String)oldScript, (String)newScript, (ProjectEntity)KeywordClassRenamingParticipant.getProjectEntity());
            PartServiceSingleton.getInstance().getPartService().saveAll(false);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private static ProjectEntity getProjectEntity() {
        return ProjectController.getInstance().getCurrentProject();
    }
}

