/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.domain;

import com.katalon.recorder.core.constant.KeywordPlatform;
import com.katalon.recorder.core.constant.ParameterType;
import com.katalon.recorder.core.domain.exception.TestCaseException;
import com.katalon.recorder.core.domain.manager.ITestCaseManager;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.IKeywordDefinition;
import com.katalon.recorder.core.domain.model.IParameter;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.domain.model.KeywordStep;
import com.katalon.recorder.core.domain.model.SingleParameter;
import com.katalon.recorder.core.domain.model.StatementStep;
import com.katalon.recorder.core.infrastructure.IKeywordDefinitionProvider;
import com.katalon.recorder.core.infrastructure.ITestCaseService;
import com.katalon.recorder.core.infrastructure.dto.ASTNodeWrapperAdapter;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.CommentWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BinaryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.VariableExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.StatementWrapper;
import com.kms.katalon.composer.testcase.util.AstEntityInputUtil;
import com.kms.katalon.core.mobile.keyword.MobileBuiltInKeywords;
import com.kms.katalon.core.webservice.keyword.WSBuiltInKeywords;
import com.kms.katalon.core.webui.keyword.WebUiBuiltInKeywords;
import com.kms.katalon.core.windows.keyword.WindowsBuiltinKeywords;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class TestCaseManager
implements ITestCaseManager {
    private final Logger logger = LoggerFactory.getLogger(TestCaseManager.class);
    private final ITestCaseService testCaseService;
    private final IKeywordDefinitionProvider keywordDefinitionProvider;

    @Inject
    public TestCaseManager(ITestCaseService testCaseService, IKeywordDefinitionProvider keywordDefinitionProvider) {
        this.testCaseService = testCaseService;
        this.keywordDefinitionProvider = keywordDefinitionProvider;
    }

    public Map<String, ASTNodeWrapperAdapter> getAstNodeWrapperAdaptersFrom(String testCaseId) throws TestCaseException {
        Map astNodeWrapperAdapters = null;
        try {
            astNodeWrapperAdapters = this.testCaseService.deserializeTestCase(testCaseId);
        }
        catch (GroovyParsingException | IllegalArgumentException e) {
            this.logger.error("Cannot deserialize test steps into AST Node Wrapper. Test case with id: " + testCaseId, e);
            return null;
        }
        return astNodeWrapperAdapters;
    }

    public List<IStep> deserializeNodeWrapperList(List<ASTNodeWrapperAdapter> nodeWrapperAdapterList) {
        ArrayList<IStep> steps = new ArrayList<IStep>();
        for (ASTNodeWrapperAdapter astNodeWrapperAdapter : nodeWrapperAdapterList) {
            IStep step = this.convertASTNodeWrapperToStep(astNodeWrapperAdapter);
            if (step == null) continue;
            steps.add(step);
        }
        return steps;
    }

    public List<IVariable> getVariablesFromTestCase(String testCaseId) throws TestCaseException {
        if (StringUtils.isBlank((CharSequence)testCaseId)) {
            return new ArrayList<IVariable>();
        }
        return this.testCaseService.getVariablesFromTestCase(testCaseId);
    }

    public ScriptNodeWrapper parseStepsIntoScriptNodeWrapper(Map<String, ASTNodeWrapperAdapter> testCaseNodeWrapperMap, List<IStep> steps) {
        ScriptNodeWrapper scriptNodeWrapper = new ScriptNodeWrapper();
        scriptNodeWrapper.addDefaultImports();
        BlockStatementWrapper mainBlock = scriptNodeWrapper.getBlock();
        for (IStep step : steps) {
            ExpressionStatementWrapper statementWrapper = null;
            if (StringUtils.isNotBlank((CharSequence)step.getAstRefId()) && testCaseNodeWrapperMap.containsKey(step.getAstRefId())) {
                ASTNodeWrapperAdapter astNodeWrapperAdapter = testCaseNodeWrapperMap.get(step.getAstRefId());
                ASTNodeWrapper aSTNodeWrapper = astNodeWrapperAdapter.getAstNodeWrapper();
                if (aSTNodeWrapper instanceof StatementWrapper) {
                    StatementWrapper existingStatement = (StatementWrapper)aSTNodeWrapper;
                    statementWrapper = existingStatement;
                }
            } else {
                statementWrapper = this.testCaseService.generateTestStep(step, scriptNodeWrapper, Collections.emptyMap());
            }
            if (statementWrapper == null) continue;
            if (StringUtils.isNotBlank((CharSequence)step.getDescription())) {
                statementWrapper.setDescription(step.getDescription());
            }
            if (step.getIsDisabled()) {
                statementWrapper.disable();
            }
            mainBlock.addStatement((StatementWrapper)statementWrapper);
        }
        return scriptNodeWrapper;
    }

    private StatementWrapper parseIStepToStatementWrapper(IStep step, ScriptNodeWrapper parentNode, Map<String, ICapturedObject> capturedObjectMap) {
        if (step instanceof KeywordStep) {
            KeywordStep keywordStep = (KeywordStep)step;
            return this.parseKeywordStepToStatementWrapper(keywordStep, parentNode);
        }
        if (step instanceof StatementStep) {
            return null;
        }
        return null;
    }

    private StatementWrapper parseKeywordStepToStatementWrapper(KeywordStep keywordStep, ScriptNodeWrapper parentNode) {
        IKeywordDefinition keywordDefinition = keywordStep.getKeywordDefinition();
        if (keywordDefinition == null) {
            return null;
        }
        String keywordClassName = this.getKeywordClassNameFromPlatform(keywordDefinition.getKeywordRef().getPlatform());
        if (keywordClassName == null) {
            return null;
        }
        MethodCallExpressionWrapper methodCallExpression = new MethodCallExpressionWrapper(keywordClassName, keywordDefinition.getKeywordRef().getName(), (ASTNodeWrapper)parentNode);
        ArgumentListExpressionWrapper argumentList = methodCallExpression.getArguments();
        List arguments = keywordStep.getArguments();
        List keywordParameters = keywordDefinition.getParameters();
        if (arguments != null) {
            int i = 0;
            while (i < keywordParameters.size()) {
                SingleParameter singleParameter;
                IParameter iParameter = (IParameter)keywordParameters.get(i);
                if (iParameter instanceof SingleParameter && ParameterType.TEST_OBJECT.equals((Object)(singleParameter = (SingleParameter)iParameter).getType())) {
                    argumentList.addExpression((ExpressionWrapper)AstEntityInputUtil.createNewFindTestObjectMethodCall((String)arguments.get(i).toString(), (ASTNodeWrapper)parentNode));
                } else {
                    String argumentText = arguments.get(i).toString();
                    ConstantExpressionWrapper constantExpression = new ConstantExpressionWrapper((Object)argumentText, (ASTNodeWrapper)argumentList);
                    argumentList.addExpression((ExpressionWrapper)constantExpression);
                }
                ++i;
            }
        }
        ExpressionStatementWrapper expressionStatement = new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpression, (ASTNodeWrapper)parentNode);
        if (StringUtils.isNotBlank((CharSequence)keywordStep.getOutput())) {
            BinaryExpressionWrapper binaryExpression = new BinaryExpressionWrapper((ASTNodeWrapper)parentNode);
            VariableExpressionWrapper leftExpression = new VariableExpressionWrapper(keywordStep.getOutput(), (ASTNodeWrapper)binaryExpression);
            binaryExpression.setLeftExpression((ExpressionWrapper)leftExpression);
            binaryExpression.setRightExpression((ExpressionWrapper)methodCallExpression);
            return new ExpressionStatementWrapper((ExpressionWrapper)binaryExpression, (ASTNodeWrapper)parentNode);
        }
        return expressionStatement;
    }

    private String getKeywordClassNameFromPlatform(KeywordPlatform platform) {
        if (platform == null) {
            return null;
        }
        switch (platform) {
            case WEB: {
                return WebUiBuiltInKeywords.class.getName();
            }
            case MOBILE: {
                return MobileBuiltInKeywords.class.getName();
            }
            case API: {
                return WSBuiltInKeywords.class.getName();
            }
            case DESKTOP: {
                return WindowsBuiltinKeywords.class.getName();
            }
        }
        return null;
    }

    private IStep convertASTNodeWrapperToStep(ASTNodeWrapperAdapter astNodeWrapperAdapter) {
        BinaryExpressionWrapper binaryExpression;
        ExpressionWrapper expressionWrapper;
        ExpressionStatementWrapper expressionStatement;
        ExpressionWrapper expressionWrapper2;
        ASTNodeWrapper aSTNodeWrapper;
        ExpressionStatementWrapper expressionStatement2;
        ExpressionWrapper expressionWrapper3;
        ASTNodeWrapper aSTNodeWrapper2;
        StatementStep step = null;
        if (this.isKeywordNodeWrapper(astNodeWrapperAdapter) && (aSTNodeWrapper2 = astNodeWrapperAdapter.getAstNodeWrapper()) instanceof ExpressionStatementWrapper && (expressionWrapper3 = (expressionStatement2 = (ExpressionStatementWrapper)aSTNodeWrapper2).getExpression()) instanceof MethodCallExpressionWrapper) {
            MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)expressionWrapper3;
            step = new KeywordStep();
            step.setKeywordDefinition(this.getKeywordDefinition(methodCall));
            ArgumentListExpressionWrapper arguments = methodCall.getArguments();
            for (ExpressionWrapper argument : arguments.getExpressions()) {
                step.addArgument((Object)argument.toString());
                step.setOutput(null);
            }
        } else if (this.isKeywordNodeWrapperWithOutput(astNodeWrapperAdapter) && (aSTNodeWrapper = astNodeWrapperAdapter.getAstNodeWrapper()) instanceof ExpressionStatementWrapper && (expressionWrapper2 = (expressionStatement = (ExpressionStatementWrapper)aSTNodeWrapper).getExpression()) instanceof BinaryExpressionWrapper && (expressionWrapper = (binaryExpression = (BinaryExpressionWrapper)expressionWrapper2).getRightExpression()) instanceof MethodCallExpressionWrapper) {
            MethodCallExpressionWrapper methodCall = (MethodCallExpressionWrapper)expressionWrapper;
            step = new KeywordStep();
            step.setKeywordDefinition(this.getKeywordDefinition(methodCall));
            ArgumentListExpressionWrapper arguments = methodCall.getArguments();
            for (ExpressionWrapper argument : arguments.getExpressions()) {
                step.addArgument((Object)argument.toString());
            }
            step.setOutput(binaryExpression.getLeftExpression().toString());
        } else {
            step = new StatementStep();
        }
        step.setAstRefId(astNodeWrapperAdapter.getAstRefId());
        step.setDescription(this.getStepDescription(astNodeWrapperAdapter));
        step.setIsDisabled(this.isDisabled(astNodeWrapperAdapter));
        return step;
    }

    /*
     * Exception decompiling
     */
    private IKeywordDefinition getKeywordDefinition(MethodCallExpressionWrapper methodCall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[8] lbl50 : CaseStatement: default:\u000a, @NONE, blocks:[8] lbl50 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getStepDescription(ASTNodeWrapperAdapter astNodeWrapperAdapter) {
        if (astNodeWrapperAdapter == null) {
            return "";
        }
        List comments = astNodeWrapperAdapter.getAstNodeWrapper().getPreceddingComments();
        if (comments == null || comments.isEmpty()) {
            return "";
        }
        return comments.stream().map(CommentWrapper::getComment).collect(Collectors.joining("\n"));
    }

    private boolean isKeywordNodeWrapper(ASTNodeWrapperAdapter astNodeWrapperAdapter) {
        ExpressionStatementWrapper expressionStatement;
        if (astNodeWrapperAdapter == null) {
            return false;
        }
        ASTNodeWrapper aSTNodeWrapper = astNodeWrapperAdapter.getAstNodeWrapper();
        return aSTNodeWrapper instanceof ExpressionStatementWrapper && (expressionStatement = (ExpressionStatementWrapper)aSTNodeWrapper).getExpression() instanceof MethodCallExpressionWrapper;
    }

    private boolean isKeywordNodeWrapperWithOutput(ASTNodeWrapperAdapter astNodeWrapperAdapter) {
        BinaryExpressionWrapper binaryExpression;
        ExpressionStatementWrapper expressionStatement;
        ExpressionWrapper expressionWrapper;
        if (astNodeWrapperAdapter == null) {
            return false;
        }
        ASTNodeWrapper aSTNodeWrapper = astNodeWrapperAdapter.getAstNodeWrapper();
        return aSTNodeWrapper instanceof ExpressionStatementWrapper && (expressionWrapper = (expressionStatement = (ExpressionStatementWrapper)aSTNodeWrapper).getExpression()) instanceof BinaryExpressionWrapper && (binaryExpression = (BinaryExpressionWrapper)expressionWrapper).getRightExpression() instanceof MethodCallExpressionWrapper;
    }

    private boolean isDisabled(ASTNodeWrapperAdapter astNodeWrapperAdapter) {
        if (astNodeWrapperAdapter == null) {
            return false;
        }
        ASTNodeWrapper aSTNodeWrapper = astNodeWrapperAdapter.getAstNodeWrapper();
        if (aSTNodeWrapper instanceof StatementWrapper) {
            StatementWrapper statement = (StatementWrapper)aSTNodeWrapper;
            return statement.isDisabled();
        }
        return false;
    }
}

