/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.infrastructure;

import com.katalon.recorder.core.constant.SingleVariableType;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.domain.model.ListVariable;
import com.katalon.recorder.core.domain.model.MapVariable;
import com.katalon.recorder.core.domain.model.SingleVariable;
import com.katalon.recorder.core.domain.model.Variable;
import com.katalon.recorder.core.infrastructure.IVariableService;
import com.katalon.recorder.util.VariableTypeProvider;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapEntryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.PropertyExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeProvider;
import com.kms.katalon.entity.variable.VariableEntity;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class VariableService
implements IVariableService {
    public List<IVariable> loadVariableFrom(List<VariableEntity> entities) {
        return entities.stream().map(this::parseEntityToVariable).collect(Collectors.toList());
    }

    public List<VariableEntity> parseToVariableEntities(List<IVariable> variables) {
        if (variables == null || variables.isEmpty()) {
            return new ArrayList<VariableEntity>();
        }
        return variables.stream().map(this::parseVariableToEntity).filter(entity -> entity != null).collect(Collectors.toList());
    }

    private VariableEntity parseVariableToEntity(IVariable variable) {
        if (variable == null) {
            return null;
        }
        VariableEntity entity = new VariableEntity();
        if (variable instanceof Variable) {
            Variable var = (Variable)variable;
            entity.setId(var.getId());
            entity.setName(var.getName());
            entity.setDescription(var.getDescription());
            entity.setMasked(var.getMasked() != null ? var.getMasked() : false);
            String defaultValue = this.convertDefaultBindingValueToString(var);
            entity.setDefaultValue(defaultValue != null ? defaultValue : "");
        } else {
            entity.setName(variable.getName());
            entity.setMasked(variable.getMasked() != null ? variable.getMasked() : false);
            entity.setDefaultValue("");
        }
        return entity;
    }

    private String convertDefaultBindingValueToString(Variable variable) {
        if (variable == null || variable.getDefaultBindingValue() == null) {
            return "null";
        }
        Object defaultValue = variable.getDefaultBindingValue();
        if (variable instanceof ListVariable) {
            return this.convertListToString(defaultValue);
        }
        if (variable instanceof MapVariable) {
            return this.convertMapToString(defaultValue);
        }
        if (variable instanceof SingleVariable) {
            return this.convertSingleValueToString(defaultValue);
        }
        return String.valueOf(defaultValue);
    }

    private String convertListToString(Object defaultValue) {
        if (!(defaultValue instanceof List) || defaultValue == null) {
            return "[]";
        }
        List list = (List)defaultValue;
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int i = 0;
        while (i < list.size()) {
            Object item = list.get(i);
            if (item instanceof ExpressionWrapper) {
                ExpressionWrapper wrapper = (ExpressionWrapper)item;
                StringBuilder itemBuilder = new StringBuilder();
                new GroovyWrapperParser(itemBuilder).parse((Object)wrapper);
                stringBuilder.append((CharSequence)itemBuilder);
            } else {
                stringBuilder.append(item);
            }
            if (i < list.size() - 1) {
                stringBuilder.append(", ");
            }
            ++i;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String convertMapToString(Object defaultValue) {
        if (!(defaultValue instanceof Map) || defaultValue == null) {
            return "[:]";
        }
        Map map = (Map)defaultValue;
        if (map.isEmpty()) {
            return "[:]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (count > 0) {
                stringBuilder.append(", ");
            }
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof ExpressionWrapper) {
                ExpressionWrapper keyWrapper = (ExpressionWrapper)key;
                StringBuilder keyBuilder = new StringBuilder();
                new GroovyWrapperParser(keyBuilder).parse((Object)keyWrapper);
                stringBuilder.append((CharSequence)keyBuilder);
            } else {
                stringBuilder.append(key);
            }
            stringBuilder.append(":");
            if (value instanceof ExpressionWrapper) {
                ExpressionWrapper valueWrapper = (ExpressionWrapper)value;
                StringBuilder valueBuilder = new StringBuilder();
                new GroovyWrapperParser(valueBuilder).parse((Object)valueWrapper);
                stringBuilder.append((CharSequence)valueBuilder);
            } else {
                stringBuilder.append(value);
            }
            ++count;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String convertSingleValueToString(Object defaultValue) {
        if (defaultValue == null) {
            return "null";
        }
        if (defaultValue instanceof String) {
            return "'" + defaultValue.toString().replace("\\", "\\\\").replace("'", "\\'") + "'";
        }
        if (defaultValue instanceof Character) {
            return "'" + String.valueOf(defaultValue) + "'";
        }
        if (defaultValue instanceof Boolean || defaultValue instanceof Number) {
            return defaultValue.toString();
        }
        if (defaultValue instanceof ExpressionWrapper) {
            StringBuilder stringBuilder = new StringBuilder();
            new GroovyWrapperParser(stringBuilder).parse((Object)((ExpressionWrapper)defaultValue));
            return stringBuilder.toString();
        }
        return String.valueOf(defaultValue);
    }

    private IVariable parseEntityToVariable(VariableEntity entity) {
        ExpressionWrapper expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression((String)entity.getDefaultValue());
        IVariable variable = this.parseExpressionToVariable(expression);
        if (variable == null) {
            return null;
        }
        variable.setId(entity.getId());
        variable.setName(entity.getName());
        variable.setMasked(Boolean.valueOf(entity.isMasked()));
        variable.setDescription(entity.getDescription());
        return variable;
    }

    private IVariable parseExpressionToVariable(ExpressionWrapper expression) {
        if (expression == null) {
            return null;
        }
        InputValueType valueType = AstInputValueTypeProvider.getInputValueTypeForASTNode((ASTNodeWrapper)expression);
        if (valueType == null) {
            throw new IllegalArgumentException("valueType is null while parsing");
        }
        ListVariable variable = null;
        switch (valueType) {
            case List: {
                variable = new ListVariable();
                if (!(expression instanceof ListExpressionWrapper)) break;
                ListExpressionWrapper listWrapper = (ListExpressionWrapper)expression;
                ArrayList<IVariable> defaultBindingValue = new ArrayList<IVariable>();
                for (ExpressionWrapper each : listWrapper.getExpressions()) {
                    defaultBindingValue.add(this.parseExpressionToVariable(each));
                }
                variable.setDefaultBindingValue(defaultBindingValue);
                break;
            }
            case Map: {
                variable = new MapVariable();
                if (!(expression instanceof MapExpressionWrapper)) break;
                MapExpressionWrapper mapWrapper = (MapExpressionWrapper)expression;
                HashMap<String, IVariable> defaultBindingValue = new HashMap<String, IVariable>();
                for (MapEntryExpressionWrapper each : mapWrapper.getMapEntryExpressions()) {
                    defaultBindingValue.put(each.getKeyExpression().getInputText(), this.parseExpressionToVariable(each.getValueExpression()));
                }
                variable.setDefaultBindingValue(defaultBindingValue);
                break;
            }
            case GlobalVariable: {
                variable = new SingleVariable();
                if (!(expression instanceof PropertyExpressionWrapper)) break;
                PropertyExpressionWrapper wrapper = (PropertyExpressionWrapper)expression;
                variable.setDefaultBindingValue((Object)(wrapper.getObjectExpressionAsString() + "." + wrapper.getPropertyAsString()));
                ((SingleVariable)variable).setSingleType(SingleVariableType.GLOBAL_VARIABLE);
                break;
            }
            default: {
                variable = new SingleVariable();
                if (expression instanceof ConstantExpressionWrapper) {
                    ConstantExpressionWrapper wrapper = (ConstantExpressionWrapper)expression;
                    variable.setDefaultBindingValue(wrapper.getValue());
                }
                ((SingleVariable)variable).setSingleType(VariableTypeProvider.getVariableTypeForASTNode(expression));
            }
        }
        return variable;
    }
}

