/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.factories;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.factories.IGroovyCompletionProcessorFactory;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.IGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.TypeCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class AnnotationCollectorTypeCompletionProcessorFactory
implements IGroovyCompletionProcessorFactory {
    @Override
    public IGroovyCompletionProcessor createProcessor(ContentAssistContext context, final JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        return new TypeCompletionProcessor(context, javaContext, nameEnvironment){

            @Override
            public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
                List<ICompletionProposal> proposals = super.generateProposals(monitor);
                if (monitor != null && monitor.isCanceled() || proposals.isEmpty()) {
                    return Collections.emptyList();
                }
                Iterator<ICompletionProposal> it = proposals.iterator();
                while (it.hasNext()) {
                    ICompletionProposal proposal = it.next();
                    if (!this.isAnnotationCollectorType(proposal)) {
                        it.remove();
                        continue;
                    }
                    GroovyCompletionProposal gcp = (GroovyCompletionProposal)((Object)ReflectionUtils.getPrivateField(LazyJavaCompletionProposal.class, (String)"fProposal", (Object)proposal));
                    gcp.setFlags(gcp.getFlags() | 0x2000);
                }
                return proposals;
            }

            @Override
            protected boolean doTypeCompletion(ContentAssistContext context, String expression) {
                return !expression.isEmpty() && super.doTypeCompletion(context, expression);
            }

            @Override
            protected int getSearchFor() {
                return 5;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected boolean isAnnotationCollectorType(ICompletionProposal proposal) {
                if (!(proposal instanceof LazyJavaTypeCompletionProposal)) return false;
                LazyJavaTypeCompletionProposal p = (LazyJavaTypeCompletionProposal)proposal;
                try {
                    IType t = javaContext.getCompilationUnit().getJavaProject().findType(p.getQualifiedTypeName());
                    if (!(t instanceof BinaryType)) return false;
                    IAnnotation[] iAnnotationArray = ((BinaryType)t).getAnnotations();
                    int n = iAnnotationArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IAnnotation a = iAnnotationArray[n2];
                        if (a.getElementName().equals("groovy.transform.AnnotationCollector")) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    GroovyContentAssist.logError("Failed to check for @AnnotationCollector in: " + p.getQualifiedTypeName(), e);
                }
                return false;
            }
        };
    }
}

