/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;

public abstract class AbstractGroovyProposal
implements IGroovyProposal {
    private float relevanceMultiplier = 1.0f;
    private String requiredQualifier;
    private String requiredStaticImport;
    private static final Set<ClassNode> EXTREMELY_COMMON_TYPES;

    static {
        HashSet<ClassNode> types = new HashSet<ClassNode>();
        types.add(VariableScope.CLASS_CLASS_NODE);
        types.add(VariableScope.OBJECT_CLASS_NODE);
        types.add(VariableScope.CLOSURE_CLASS_NODE);
        types.add(VariableScope.GROOVY_OBJECT_CLASS_NODE);
        types.add(VariableScope.GROOVY_SUPPORT_CLASS_NODE);
        EXTREMELY_COMMON_TYPES = Collections.unmodifiableSet(types);
    }

    public AnnotatedNode getAssociatedNode() {
        return null;
    }

    public int getAssociatedNodeFlags() {
        AnnotatedNode node = this.getAssociatedNode();
        if (node instanceof ClassNode) {
            return ((ClassNode)node).getModifiers();
        }
        if (node instanceof FieldNode) {
            return ((FieldNode)node).getModifiers();
        }
        if (node instanceof MethodNode) {
            return ((MethodNode)node).getModifiers();
        }
        if (node instanceof PropertyNode) {
            return ((PropertyNode)node).getModifiers();
        }
        return 0;
    }

    public final float getRelevanceMultiplier() {
        return this.relevanceMultiplier;
    }

    public final void setRelevanceMultiplier(float relevanceMultiplier) {
        this.relevanceMultiplier = relevanceMultiplier;
    }

    public final String getRequiredQualifier() {
        return this.requiredQualifier;
    }

    public final void setRequiredQualifier(String requiredQualifier) {
        this.requiredQualifier = requiredQualifier;
    }

    public final String getRequiredStaticImport() {
        return this.requiredStaticImport;
    }

    public final void setRequiredStaticImport(String requiredStaticImport) {
        this.requiredStaticImport = requiredStaticImport;
    }

    protected int computeRelevance(ContentAssistContext context) {
        int relevance = this.getRelevanceClass().getRelevance(this.getRelevanceMultiplier());
        AnnotatedNode node = this.getAssociatedNode();
        if (node != null) {
            if (context.lhsType != null) {
                ClassNode type = null;
                if (node instanceof FieldNode) {
                    type = ((FieldNode)node).getType();
                } else if (node instanceof MethodNode) {
                    type = ((MethodNode)node).getReturnType();
                } else if (node instanceof PropertyNode) {
                    type = ((PropertyNode)node).getType();
                }
                if (type != null && GroovyUtils.isAssignable((ClassNode)type, (ClassNode)context.lhsType)) {
                    relevance = Math.max(relevance, Relevance.HIGH.getRelevance());
                }
            }
            if (StringGroovyMethods.asBoolean((CharSequence)context.completionExpression)) {
                String name = null;
                if (node instanceof FieldNode) {
                    name = ((FieldNode)node).getName();
                } else if (node instanceof MethodNode) {
                    name = ((MethodNode)node).getName();
                } else if (node instanceof PropertyNode) {
                    name = ((PropertyNode)node).getName();
                }
                if (StringGroovyMethods.asBoolean((CharSequence)name)) {
                    String expr = context.getPerceivedCompletionExpression();
                    if (name.equals(expr)) {
                        relevance += 14;
                    } else if (name.equalsIgnoreCase(expr)) {
                        relevance += 4;
                    } else if (CharOperation.prefixEquals((char[])expr.toCharArray(), (char[])name.toCharArray(), (boolean)false)) {
                        if (name.startsWith(expr)) {
                            relevance += 10;
                        }
                    } else if (SearchPattern.camelCaseMatch((String)expr, (String)name)) {
                        relevance += 5;
                    } else if (CharOperation.substringMatch((String)expr, (String)name)) {
                        relevance -= 21;
                    }
                }
            }
        }
        if (relevance > 1 && this instanceof GroovyMethodProposal) {
            relevance = (int)((float)relevance * 0.99f);
        }
        return Math.max(relevance, 5);
    }

    private Relevance getRelevanceClass() {
        AnnotatedNode node = this.getAssociatedNode();
        if (node != null && EXTREMELY_COMMON_TYPES.contains(node.getDeclaringClass())) {
            return Relevance.VERY_LOW;
        }
        if (node instanceof FieldNode || node instanceof MethodNode || node instanceof PropertyNode) {
            return Relevance.MEDIUM_HIGH;
        }
        return Relevance.MEDIUM;
    }
}

