/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.application.service;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.onboarding.core.application.service.IKnowledgeManager;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.KnowledgeItem;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourProgress;
import com.kms.katalon.onboarding.core.domain.repository.ITourRepository;
import com.kms.katalon.onboarding.domain.event.OnboardingStepCompletedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourCompletedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourStartedEvent;
import com.kms.katalon.onboarding.domain.event.OnboardingTourTerminatedEvent;
import com.kms.katalon.onboarding.domain.tour.IStepListener;
import com.kms.katalon.onboarding.domain.tour.StepGroupHandler;
import com.kms.katalon.onboarding.domain.tour.StepHandler;
import com.kms.katalon.onboarding.domain.tour.TourHandler;
import com.kms.katalon.onboarding.onboardingtour.IOnboardingTourRegistry;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;

@Creatable
@Singleton
public class KnowledgeManager
implements IKnowledgeManager {
    @Inject
    private ITourRepository tourRepository;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IOnboardingTourRegistry tourRegistry;
    private int weightPercentagePerStep = 0;

    public void startTour(OnboardingTour tour) throws Exception {
        TourHandler tourHandler;
        if (tour == null) {
            return;
        }
        if (this.eventBroker != null) {
            this.eventBroker.post("ONBOARDING/TOUR_STARTED", (Object)new OnboardingTourStartedEvent(tour));
        }
        if ((tourHandler = this.tourRegistry.getTourHandler(tour)) == null) {
            LoggerSingleton.logError((String)OnboardingMessageConstants.ERROR_UNABLE_TO_CREATE_ONBOARDING_TOUR);
            MultiStatusErrorDialog.showErrorDialog((String)OnboardingMessageConstants.ERROR_DIALOG_TITLE_ONBOARDING_TOUR_ERROR, (String)OnboardingMessageConstants.ERROR_UNABLE_TO_CREATE_ONBOARDING_TOUR, (String)OnboardingMessageConstants.ERROR_TOUR_NOT_FOUND);
            return;
        }
        tourHandler.ensureOnboardingReady();
        this.weightPercentagePerStep = this.calculateWeightPercentagePerStep(tourHandler);
        StepHandler firstStepHandler = this.getFirstStepHandler(tourHandler);
        if (firstStepHandler != null) {
            Trackings.trackOnboardingTourStart((String)tourHandler.getTour().getId());
            OnboardingTourProgress progress = new OnboardingTourProgress(tour.getId(), 0, 0, new ArrayList());
            this.tourRepository.updateProgress(progress);
            this.executeStep(firstStepHandler, tourHandler);
        } else {
            Trackings.trackOnboardingTourComplete((String)tourHandler.getTour().getId());
        }
    }

    public void startKnowledgeItem(KnowledgeItem item) throws IOException, URISyntaxException {
        if (item == null) {
            return;
        }
        Desktop.getDesktop().browse(new URI(item.getUrl()));
    }

    public void rateTour(OnboardingTour tour, OnboardingTourProgress progress, String feedback) throws UnsupportedEncodingException {
        this.tourRepository.updateProgress(progress);
        Trackings.trackOnboardingTourFeedback((String)tour.getId(), (int)progress.getRating(), (String)feedback);
        this.eventBroker.post("ONBOARDING/TOUR_COMPLETED", (Object)new OnboardingTourCompletedEvent(tour, progress));
    }

    private StepHandler getFirstStepHandler(TourHandler tourHandler) {
        if (!tourHandler.getStepGroupHandlers().isEmpty() && !tourHandler.getStepGroupHandlers().get(0).getStepHandlers().isEmpty()) {
            return tourHandler.getStepGroupHandlers().get(0).getStepHandlers().get(0);
        }
        return null;
    }

    private void executeStep(final StepHandler currentStep, final TourHandler tourHandler) {
        currentStep.addStepListener(new IStepListener(){

            @Override
            public void onExit() {
                tourHandler.cleanup();
                KnowledgeManager.this.eventBroker.post("ONBOARDING/TOUR_TERMINATED", (Object)new OnboardingTourTerminatedEvent(tourHandler.getTour()));
                Trackings.trackOnboardingTourExit((String)tourHandler.getTour().getId(), (boolean)true);
            }

            @Override
            public void onActionCompleted() throws UnsupportedEncodingException {
                OnboardingTour tour = tourHandler.getTour();
                OnboardingTourProgress progress = KnowledgeManager.this.tourRepository.getProgressById(tour.getId());
                int newPercentage = progress.getPercentage() + KnowledgeManager.this.weightPercentagePerStep;
                if (newPercentage > 100) {
                    newPercentage = 100;
                }
                progress.setPercentage(newPercentage);
                KnowledgeManager.this.tourRepository.updateProgress(progress);
                KnowledgeManager.this.eventBroker.post("ONBOARDING/STEP_COMPLETED", (Object)new OnboardingStepCompletedEvent(tour, progress));
                Trackings.trackOnboardingTourCompletedStep((String)currentStep.getId(), (String)tour.getId());
                StepHandler nextStep = KnowledgeManager.this.findNextStep(tourHandler, currentStep);
                if (nextStep != null) {
                    KnowledgeManager.this.executeStep(nextStep, tourHandler);
                } else {
                    tourHandler.cleanup();
                    progress.setPercentage(100);
                    progress.addCompletedGroupId(currentStep.getGroup().getId());
                    KnowledgeManager.this.tourRepository.updateProgress(progress);
                    KnowledgeManager.this.eventBroker.post("ONBOARDING/TOUR_COMPLETED", (Object)new OnboardingTourCompletedEvent(tour, progress));
                }
            }

            @Override
            public void onError(Exception e) {
                LoggerSingleton.logError((String)MessageFormat.format(OnboardingMessageConstants.ERROR_SETUP_ONBOARDING_STEP, e));
                tourHandler.cleanup();
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)OnboardingMessageConstants.ERROR_DIALOG_TITLE_ONBOARDING_TOUR_ERROR, (String)MessageFormat.format(OnboardingMessageConstants.ERROR_SETUP_ONBOARDING_STEP, currentStep.getId()));
            }

            @Override
            public void onResume() {
                Trackings.trackOnboardingTourExit((String)tourHandler.getTour().getId(), (boolean)false);
            }
        });
        currentStep.setUp();
    }

    private StepHandler findNextStep(TourHandler tourHandler, StepHandler currentStep) throws UnsupportedEncodingException {
        int groupIndex = 0;
        while (groupIndex < tourHandler.getStepGroupHandlers().size()) {
            StepGroupHandler stepGroup = tourHandler.getStepGroupHandlers().get(groupIndex);
            int stepIndex = 0;
            while (stepIndex < stepGroup.getStepHandlers().size()) {
                if (stepGroup.getStepHandlers().get(stepIndex) == currentStep) {
                    StepGroupHandler nextGroup;
                    if (stepIndex + 1 < stepGroup.getStepHandlers().size()) {
                        return stepGroup.getStepHandlers().get(stepIndex + 1);
                    }
                    if (groupIndex + 1 < tourHandler.getStepGroupHandlers().size() && !(nextGroup = tourHandler.getStepGroupHandlers().get(groupIndex + 1)).getStepHandlers().isEmpty()) {
                        return nextGroup.getStepHandlers().get(0);
                    }
                    return null;
                }
                ++stepIndex;
            }
            OnboardingTour tour = tourHandler.getTour();
            OnboardingTourProgress progress = this.tourRepository.getProgressById(tour.getId());
            progress.addCompletedGroupId(stepGroup.getId());
            this.tourRepository.updateProgress(progress);
            this.eventBroker.post("ONBOARDING/STEP_COMPLETED", (Object)new OnboardingStepCompletedEvent(tour, progress));
            ++groupIndex;
        }
        return null;
    }

    private int calculateWeightPercentagePerStep(TourHandler tourHandler) {
        int totalSteps = 0;
        for (StepGroupHandler stepGroupHandler : tourHandler.getStepGroupHandlers()) {
            totalSteps += stepGroupHandler.getStepHandlers().size();
        }
        return totalSteps > 0 ? 100 / totalSteps : 0;
    }
}

