/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.presentation.popover;

public class WebPopoverBuilder {
    private static final String DEFAULT_PORT = "60611";
    private String port = "60611";
    private String elementSelector;
    private SelectorType selectorType = SelectorType.ID;
    private PopoverLocation location = PopoverLocation.BOTTOM;
    private boolean enableNextButton = false;
    private String description = "";
    private String validationValue = "";

    public WebPopoverBuilder withPort(String port) {
        this.port = port;
        return this;
    }

    public WebPopoverBuilder withElementId(String id) {
        this.elementSelector = id;
        this.selectorType = SelectorType.ID;
        return this;
    }

    public WebPopoverBuilder withElementClass(String className) {
        this.elementSelector = className;
        this.selectorType = SelectorType.CLASS_NAME;
        return this;
    }

    public WebPopoverBuilder withElementSelector(String cssSelector) {
        this.elementSelector = cssSelector;
        this.selectorType = SelectorType.CSS_SELECTOR;
        return this;
    }

    public WebPopoverBuilder withLocation(PopoverLocation location) {
        this.location = location;
        return this;
    }

    public WebPopoverBuilder withNextButton(boolean enable) {
        this.enableNextButton = enable;
        return this;
    }

    public WebPopoverBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public WebPopoverBuilder withValidationValue(String validationValue) {
        this.validationValue = validationValue;
        return this;
    }

    public String build() {
        String notifyJavaBackend = String.format("\tfunction notifyJavaBackend(action) {\n\t\tfetch('http://localhost:%s/' + action, {method:'POST'});\n\t}\n", this.port);
        String js = "\tfunction disableKatalonHighlighting() {\n\t\tconst style = document.createElement('style');\n\t\tstyle.textContent = '* { outline: none !important; }';\n\t\tdocument.head.appendChild(style);\n\n\t\tconst desc = Object.getOwnPropertyDescriptor(CSSStyleDeclaration.prototype, 'outline');\n\t\tif (desc && desc.get) {\n\t\t\tObject.defineProperty(CSSStyleDeclaration.prototype, 'outline', {\n\t\t\t\tset: function() {},\n\t\t\t\tget: desc.get\n\t\t\t});\n\t\t} else {\n\t\t\tObject.defineProperty(CSSStyleDeclaration.prototype, 'outline', {\n\t\t\t\tset: function() {},\n\t\t\t\tget: function() { return ''; },\n\t\t\t\tconfigurable: true\n\t\t\t});\n\t\t}\n\t\tconsole.log('Katalon highlighting disabled');\n\t}\nfunction injectAnnotationCardStyles() {\n\tconst styleElement = document.createElement('style');\n\tstyleElement.textContent = `\n\t\t.annotation-card {\n\t\t\tborder-radius: 4px;\n\t\t\tbox-shadow: 0px 4px 8px rgba(0, 0, 0, 0.15);\n\t\t\tmax-width: 320px;\n\t\t\tposition: absolute;\n\t\t\twidth: 100%;\n\t\t\tz-index: 9999;\n\t\t\tbackground-color: #0f8461;\n\t\t\tborder-radius: 6px;\n\t\t\tpadding: 8px;\n\t\t}\n\t\t.annotation-card .arrow {\n\t\t\tdisplay: none;\n\t\t\tposition: absolute;\n\t\t\twidth: 18px;\n\t\t\theight: 18px;\n\t\t\tbackground: #0f8461;\n\t\t\tz-index: 10001;\n\t\t}\n\t\t.annotation-card.arrow-bottom .arrow {\n\t\t\tdisplay: block;\n\t\t\ttop: -9px;\n\t\t\tleft: 20px;\n\t\t\tclip-path: polygon(50% 0, 100% 100%, 0 100%);\n\t\t}\n\t\t.annotation-card.arrow-top .arrow {\n\t\t\tdisplay: block;\n\t\t\tbottom: -9px;\n\t\t\tleft: 20px;\n\t\t\tclip-path: polygon(0 0, 100% 0, 50% 100%);\n\t\t}\n\t\t.annotation-card.arrow-right .arrow {\n\t\t\tdisplay: block;\n\t\t\tleft: -9px;\n\t\t\ttop: 10px;\n\t\t\tclip-path: polygon(0 50%, 100% 0, 100% 100%);\n\t\t}\n\t\t.annotation-card.arrow-left .arrow {\n\t\t\tdisplay: block;\n\t\t\tright: -9px;\n\t\t\ttop: 10px;\n\t\t\tclip-path: polygon(100% 50%, 0 0, 0 100%);\n\t\t}\n\t\t.content-section {\n\t\t\tposition: relative;\n\t\t\tpadding-top: 2px;\n\t\t\talign-self: flex-start;\n\t\t\twidth: 100%;\n\t\t\tmargin: 2px;\n\t\t\ttext-align: left;\n\t\t}\n\t\t.content-wrapper {\n\t\t\tmax-width: 280px;\n\t\t\tpadding: 5px 10px;\n\t\t\ttext-align: left;\n\t\t}\n\t\t.header-row {\n\t\t\tdisplay: flex;\n\t\t\twidth: 100%;\n\t\t\talign-items: flex-start;\n\t\t\tgap: 8px;\n\t\t\tcolor: #ffffff;\n\t\t\tmargin-bottom: 5px;\n\t\t}\n\t\t.icon-wrapper {\n\t\t\tdisplay: flex;\n\t\t\tpadding-top: 2px;\n\t\t\talign-items: center;\n\t\t\tgap: 10px;\n\t\t\tfont-family: \"Font Awesome 6 Pro\", -apple-system, Roboto, Helvetica, sans-serif;\n\t\t\tfont-size: 15px;\n\t\t\tfont-weight: 400;\n\t\t\twhite-space: nowrap;\n\t\t\ttext-align: center;\n\t\t\twidth: 15px;\n\t\t}\n\t\t.delete-icon {\n\t\t\talign-self: stretch;\n\t\t\tmargin: auto;\n\t\t\twidth: 100%;\n\t\t\tpadding: 2px;\n\t\t\toverflow: hidden;\n\t\t\tflex: 1;\n\t\t}\n\t\t.description {\n\t\t\tcolor: #ffffff;\n\t\t\tfont-family: Inter, -apple-system, Roboto, Helvetica, sans-serif;\n\t\t\tfont-size: 15px;\n\t\t\tfont-weight: 400;\n\t\t\tline-height: 1.4;\n\t\t\tmargin: 5px 0;\n\t\t\ttext-align: left;\n\t\t}\n\t\t.metadata {\n\t\t\tcolor: rgba(255, 255, 255, 0.7);\n\t\t\tfont-family: Inter, -apple-system, Roboto, Helvetica, sans-serif;\n\t\t\tfont-size: 12px;\n\t\t\tfont-weight: 400;\n\t\t\tmargin-top: 5px;\n\t\t\ttext-align: left;\n\t\t}\n\t\t.card-footer {\n\t\t\tposition: relative;\n\t\t\tborder-radius: 0 0 4px 4px;\n\t\t\tdisplay: flex;\n\t\t\tmargin-top: 10px;\n\t\t\tmin-height: 40px;\n\t\t\tpadding: 8px 0;\n\t\t\talign-items: center;\n\t\t\tfont-family: Inter, -apple-system, Roboto, Helvetica, sans-serif;\n\t\t\tcolor: #ffffff;\n\t\t\tfont-weight: 400;\n\t\t\twhite-space: nowrap;\n\t\t}\n\t\t.footer-content {\n\t\t\tdisplay: flex;\n\t\t\tmargin: auto;\n\t\t\twidth: 100%;\n\t\t\tpadding: 0 12px;\n\t\t\talign-items: center;\n\t\t\tjustify-content: space-between;\n\t\t\tflex: 1;\n\t\t}\n\t\t.step-counter {\n\t\t\tfont-size: 15px;\n\t\t\tline-height: 1;\n\t\t\talign-self: center;\n\t\t}\n\t\t.button-wrapper {\n\t\t\tdisplay: flex;\n\t\t\talign-items: center;\n\t\t\tgap: 4px;\n\t\t\tfont-size: 15px;\n\t\t\ttext-align: center;\n\t\t\tletter-spacing: -0.08px;\n\t\t\tline-height: 1;\n\t\t\twidth: 70px;\n\t\t}\n\t\t.next-button {\n\t\t\twidth: 100%;\n\t\t\tborder-radius: 5px;\n\t\t\tbox-shadow: 0px 1px 2px rgba(0, 0, 0, 0.05);\n\t\t\tborder: 1px solid rgba(205, 206, 205, 0.6);\n\t\t\tmin-height: 28px;\n\t\t\tpadding: 4px 10px;\n\t\t\tbackground: transparent;\n\t\t\tcolor: #ffffff;\n\t\t\tfont-family: inherit;\n\t\t\tfont-size: inherit;\n\t\t\tcursor: pointer;\n\t\t}\n\t\t.close-button {\n\t\t\tposition: absolute;\n\t\t\ttop: 4px;\n\t\t\tright: 4px;\n\t\t\twidth: 30px;\n\t\t\theight: 30px;\n\t\t\tcolor: #ffffff;\n\t\t\tborder: none;\n\t\t\tbackground: transparent;\n\t\t\tfont-size: 20px;\n\t\t\ttext-align: center;\n\t\t\tline-height: 20px;\n\t\t\tcursor: pointer;\n\t\t\tz-index: 10000;\n\t\t}\n\t`;\n\tdocument.head.appendChild(styleElement);\n\treturn styleElement;\n}\nfunction createAnnotationCard(direction, enableNextButton, description) {\n\tconst annotationCard = document.createElement('div');\n\tlet arrowClass = 'arrow-bottom';\n\tif (direction === 'TOP') arrowClass = 'arrow-top';\n\telse if (direction === 'LEFT') arrowClass = 'arrow-left';\n\telse if (direction === 'RIGHT') arrowClass = 'arrow-right';\n\tannotationCard.className = 'annotation-card ' + arrowClass;\n\n\tannotationCard.innerHTML =\n\t\t'<div class=\"arrow\"></div>' +\n\t\t'<article>' +\n\t\t'<button class=\"close-button\">&times;</button>' +\n\t\t'<header class=\"content-section\">' +\n\t\t'<div class=\"content-wrapper\">' +\n\t\t'<p class=\"description\">' + description + '</p>' +\n\t\t'</div>' +\n\t\t'</header>' +\n\t\t(enableNextButton ?\n\t\t\t('<footer class=\"card-footer\">' +\n\t\t\t\t'<div class=\"footer-content\">' +\n\t\t\t\t'<div class=\"button-wrapper\">' +\n\t\t\t\t'<button class=\"next-button\">Next</button>' +\n\t\t\t\t'</div>' +\n\t\t\t\t'</div>' +\n\t\t\t\t'</footer>')\n\t\t\t: '') +\n\t\t'</article>';\n\treturn annotationCard;\n}\n\t// Helper function to block all user interactions on an overlay element\n\tfunction blockAllInteractions(overlay) {\n\t\tconst preventAllInteractions = function(e) {\n\t\t\te.stopPropagation();\n\t\t\te.preventDefault();\n\t\t\te.stopImmediatePropagation();\n\t\t\treturn false;\n\t\t};\n\n\t\tconst eventTypes = [\n\t\t\t// Mouse events\n\t\t\t'click', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout',\n\t\t\t'mouseenter', 'mouseleave', 'contextmenu', 'dblclick',\n\t\t\t// Keyboard events\n\t\t\t'keydown', 'keyup', 'keypress',\n\t\t\t// Touch events\n\t\t\t'touchstart', 'touchend', 'touchmove', 'touchcancel',\n\t\t\t// Focus events\n\t\t\t'focus', 'blur', 'focusin', 'focusout',\n\t\t\t// Drag events\n\t\t\t'dragstart', 'drag', 'dragend', 'drop', 'dragover', 'dragenter', 'dragleave',\n\t\t\t// Scroll events\n\t\t\t'wheel', 'scroll'\n\t\t];\n\n\t\teventTypes.forEach(eventType => {\n\t\t\toverlay.addEventListener(eventType, preventAllInteractions, true);\n\t\t});\n\t}\n\n\t// Helper function to set common overlay styles and behavior\n\tfunction setupOverlayElement(targetElement) {\n\t\tdocument.body.style.overflow = 'hidden';\n\t\ttargetElement.style.position = 'relative';\n\t\ttargetElement.style.zIndex = '10001';\n\t\ttargetElement.style.pointerEvents = 'auto';\n\t}\n\n\t// Helper function to clean up overlay styles\n\tfunction cleanupOverlayStyles(targetElement) {\n\t\tdocument.body.style.overflow = '';\n\t\ttargetElement.style.zIndex = '';\n\t\ttargetElement.style.pointerEvents = '';\n\t}\n\n\tfunction createDimOverlayWithHole(targetElement) {\n\t\tconst rect = targetElement.getBoundingClientRect();\n\t\tconst overlays = [];\n\n\t\tfunction createOverlayDiv(styles) {\n\t\t\tconst overlay = document.createElement('div');\n\t\t\tObject.assign(overlay.style, {\n\t\t\t\tposition: 'fixed',\n\t\t\t\tbackground: 'rgba(0, 0, 0, 0.4)',\n\t\t\t\tzIndex: '9998',\n\t\t\t\tpointerEvents: 'auto'\n\t\t\t}, styles);\n\n\t\t\tblockAllInteractions(overlay);\n\t\t\tdocument.body.appendChild(overlay);\n\t\t\toverlays.push(overlay);\n\t\t\treturn overlay;\n\t\t}\n\n\t\t// Create overlay parts around the target element\n\t\tcreateOverlayDiv({\n\t\t\ttop: '0px',\n\t\t\tleft: '0px',\n\t\t\twidth: '100vw',\n\t\t\theight: rect.top + 'px'\n\t\t});\n\n\t\tcreateOverlayDiv({\n\t\t\ttop: rect.bottom + 'px',\n\t\t\tleft: '0px',\n\t\t\twidth: '100vw',\n\t\t\theight: `calc(100vh - ${rect.bottom}px)`\n\t\t});\n\n\t\tcreateOverlayDiv({\n\t\t\ttop: rect.top + 'px',\n\t\t\tleft: '0px',\n\t\t\twidth: rect.left + 'px',\n\t\t\theight: rect.height + 'px'\n\t\t});\n\n\t\tcreateOverlayDiv({\n\t\t\ttop: rect.top + 'px',\n\t\t\tleft: rect.right + 'px',\n\t\t\twidth: `calc(100vw - ${rect.right}px)`,\n\t\t\theight: rect.height + 'px'\n\t\t});\n\n\t\tsetupOverlayElement(targetElement);\n\n\t\tfunction removeOverlay() {\n\t\t\toverlays.forEach(overlay => overlay.remove());\n\t\t\tcleanupOverlayStyles(targetElement);\n\t\t}\n\n\t\treturn removeOverlay;\n\t}\n\n\tfunction createDimOverlay(targetElement) {\n\t\tconst isDatepickerTarget = targetElement.closest('.datepicker') ||\n\t\t                          targetElement.classList.contains('datepicker')\n\n\t\tif (isDatepickerTarget) {\n\t\t\treturn createDimOverlayWithHole(targetElement);\n\t\t}\n\n\t\tconst overlay = document.createElement('div');\n\t\tObject.assign(overlay.style, {\n\t\t\tposition: 'fixed',\n\t\t\ttop: '0',\n\t\t\tleft: '0',\n\t\t\twidth: '100vw',\n\t\t\theight: '100vh',\n\t\t\tbackground: 'rgba(0, 0, 0, 0.4)',\n\t\t\tzIndex: '9998',\n\t\t\tpointerEvents: 'auto'\n\t\t});\n\n\t\tblockAllInteractions(overlay);\n\t\tsetupOverlayElement(targetElement);\n\t\tdocument.body.appendChild(overlay);\n\n\t\tfunction removeOverlay() {\n\t\t\toverlay.remove();\n\t\t\tcleanupOverlayStyles(targetElement);\n\t\t}\n\n\t\treturn removeOverlay;\n\t}\n" + notifyJavaBackend + "\tfunction findElementWithTimeout(elementSelector, selectorType, timeoutMs) {\n\t\treturn new Promise((resolve, reject) => {\n\t\t\tconst startTime = Date.now();\n\t\t\tconst interval = 100;\n\n\t\t\tfunction checkElement() {\n\t\t\t\tvar targetElement = null;\n\n\t\t\t\tif (selectorType === 'id') {\n\t\t\t\t\ttargetElement = document.getElementById(elementSelector);\n\t\t\t\t} else if (selectorType === 'class') {\n\t\t\t\t\tvar elements = document.getElementsByClassName(elementSelector);\n\t\t\t\t\tif (elements.length > 0) {\n\t\t\t\t\t\ttargetElement = elements[0];\n\t\t\t\t\t}\n\t\t\t\t} else if (selectorType === 'selector') {\n\t\t\t\t\ttargetElement = document.querySelector(elementSelector);\n\t\t\t\t}\n\n\t\t\t\tif (targetElement) {\n\t\t\t\t\tresolve(targetElement);\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tif (Date.now() - startTime >= timeoutMs) {\n\t\t\t\t\treject(new Error(\"Element with \" + selectorType + \" '\" + elementSelector + \"' not found within \" + timeoutMs + \"ms timeout.\"));\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tsetTimeout(checkElement, interval);\n\t\t\t}\n\n\t\t\tcheckElement();\n\t\t});\n\t}\t\tfunction createPositionMonitor(targetElement, annotationCard, location) {\n\t\tlet isMonitoring = true;\n\t\tlet lastRect = null;\n\n\t\tfunction updatePopoverPosition() {\n\t\t\tif (!isMonitoring || !targetElement || !annotationCard) return;\n\n\t\t\tconst currentRect = targetElement.getBoundingClientRect();\n\t\t\tconst scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;\n\t\t\tconst scrollTop = window.pageYOffset || document.documentElement.scrollTop;\n\n\t\t\tif (!lastRect ||\n\t\t\t\tlastRect.left !== currentRect.left ||\n\t\t\t\tlastRect.top !== currentRect.top ||\n\t\t\t\tlastRect.width !== currentRect.width ||\n\t\t\t\tlastRect.height !== currentRect.height) {\n\n\t\t\t\tlastRect = {\n\t\t\t\t\tleft: currentRect.left,\n\t\t\t\t\ttop: currentRect.top,\n\t\t\t\t\twidth: currentRect.width,\n\t\t\t\t\theight: currentRect.height\n\t\t\t\t};\n\n\t\t\t\tconst cardWidth = annotationCard.offsetWidth || 320;\n\t\t\t\tconst cardHeight = annotationCard.offsetHeight || 120;\n\t\t\t\tlet left = currentRect.left + scrollLeft;\n\t\t\t\tlet top = currentRect.top + scrollTop + currentRect.height + 5;\n\n\t\t\t\tif (location === 'TOP') {\n\t\t\t\t\ttop = currentRect.top + scrollTop - cardHeight - 5;\n\t\t\t\t\tleft = currentRect.left + scrollLeft;\n\t\t\t\t} else if (location === 'LEFT') {\n\t\t\t\t\tleft = currentRect.left + scrollLeft - cardWidth - 5;\n\t\t\t\t\ttop = currentRect.top + scrollTop;\n\t\t\t\t} else if (location === 'RIGHT') {\n\t\t\t\t\tleft = currentRect.left + scrollLeft + currentRect.width + 5;\n\t\t\t\t\ttop = currentRect.top + scrollTop;\n\t\t\t\t}\n\n\t\t\t\tannotationCard.style.left = left + 'px';\n\t\t\t\tannotationCard.style.top = top + 'px';\n\t\t\t}\n\t\t}\n\n\t\tconst resizeObserver = new ResizeObserver(updatePopoverPosition);\n\t\tresizeObserver.observe(targetElement);\n\n\t\twindow.addEventListener('scroll', updatePopoverPosition, true);\n\t\twindow.addEventListener('resize', updatePopoverPosition);\n\n\t\tconst pollInterval = setInterval(updatePopoverPosition, 200);\n\n\t\tfunction stopMonitoring() {\n\t\t\tisMonitoring = false;\n\t\t\tresizeObserver.disconnect();\n\t\t\twindow.removeEventListener('scroll', updatePopoverPosition, true);\n\t\t\twindow.removeEventListener('resize', updatePopoverPosition);\n\t\t\tclearInterval(pollInterval);\n\t\t}\n\n\t\treturn { stopMonitoring };\n\t}\n\n\tasync function showPopover(options) {\n\t\tdisableKatalonHighlighting();\n\n\t\tif (typeof options !== 'object') {\n\t\t\tvar elementId = arguments[0];\n\t\t\tvar location = arguments[1] || 'BOTTOM';\n\t\t\tvar enableNextButton = arguments[2] !== undefined ? arguments[2] : true;\n\t\t\tvar description = arguments[3] || '';\n\t\t\tvar validationValue = arguments[4] || '';\n\n\t\t\toptions = {\n\t\t\t\telementSelector: elementId,\n\t\t\t\tselectorType: 'id',\n\t\t\t\tlocation: location,\n\t\t\t\tenableNextButton: enableNextButton,\n\t\t\t\tdescription: description,\n\t\t\t\tvalidationValue: validationValue\n\t\t\t};\n\t\t}\n\n\t\tvar elementSelector = options.elementSelector || options.elementId;\n\t\tvar selectorType = options.selectorType || 'id';\n\t\tvar location = options.location || 'BOTTOM';\n\t\tvar enableNextButton = options.enableNextButton !== undefined ? options.enableNextButton : true;\n\t\tvar description = options.description || '';\n\t\tvar validationValue = options.validationValue || '';\n\n\t\ttry {\n\t\t\tvar targetElement = await findElementWithTimeout(elementSelector, selectorType, 3000);\n\n\t\t\tvar removeOverlay = createDimOverlay(targetElement);\n\t\t\tvar styleElement = injectAnnotationCardStyles();\n\t\t\tvar annotationCard = createAnnotationCard(location, enableNextButton, description);\n\t\t\tdocument.body.appendChild(annotationCard);\n\t\t\tvar card = annotationCard;\n\t\t\tcard.style.width = '320px';\n\t\t\tvar targetRect = targetElement.getBoundingClientRect();\n\t\t\tvar scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;\n\t\t\tvar scrollTop = window.pageYOffset || document.documentElement.scrollTop;\n\t\t\tvar cardWidth = card.offsetWidth || 320;\n\t\t\tvar cardHeight = card.offsetHeight || 120;\n\t\t\tvar left = targetRect.left + scrollLeft;\n\t\t\tvar top = targetRect.top + scrollTop + targetRect.height + 5;\n\n\t\t\tif (location === 'TOP') {\n\t\t\t\ttop = targetRect.top + scrollTop - cardHeight - 5;\n\t\t\t\tleft = targetRect.left + scrollLeft;\n\t\t\t} else if (location === 'LEFT') {\n\t\t\t\tleft = targetRect.left + scrollLeft - cardWidth - 5;\n\t\t\t\ttop = targetRect.top + scrollTop;\n\t\t\t} else if (location === 'RIGHT') {\n\t\t\t\tleft = targetRect.left + scrollLeft + targetRect.width + 5;\n\t\t\t\ttop = targetRect.top + scrollTop;\n\t\t\t}\n\n\t\t\tcard.style.position = 'absolute';\n\t\t\tcard.style.left = left + 'px';\n\t\t\tcard.style.top = top + 'px';\n\n\t\t\tconst positionMonitor = createPositionMonitor(targetElement, annotationCard, location);\n\t\t\tvar nextButton = card.querySelector('.next-button');\n\t\t\tvar closeButton = card.querySelector('.close-button');\n\n\t\t\tfunction closeCardAndOverlay() {\n\t\t\t\tpositionMonitor.stopMonitoring();\n\t\t\t\tannotationCard.remove();\n\t\t\t\tstyleElement.remove();\n\t\t\t\tremoveOverlay();\n\t\t\t\tenableKeyboardActions();\n\t\t\t}\n\n\t\t\tvar keyboardBlocker = null;\n\n\t\t\tfunction disableKeyboardActions() {\n\t\t\t\tkeyboardBlocker = function(event) {\n\t\t\t\t\tif (targetElement && (targetElement.tagName === 'INPUT' || targetElement.tagName === 'TEXTAREA')\n\t\t\t\t\t\t&& event.target === targetElement) {\n\t\t\t\t\t\tvar isTypingKey = event.key.length === 1 ||\n\t\t\t\t\t\t\t\t\t\tevent.key === 'Backspace' ||\n\t\t\t\t\t\t\t\t\t\tevent.key === 'Delete';\n\t\t\t\t\t\tif (isTypingKey) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\n\t\t\t\t\tvar blockedKeys = [\n\t\t\t\t\t\t'Enter', 'Tab', 'Escape',\n\t\t\t\t\t\t'ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight',\n\t\t\t\t\t\t'PageUp', 'PageDown', 'Home', 'End',\n\t\t\t\t\t\t'F1', 'F2', 'F3', 'F4', 'F5', 'F6',\n\t\t\t\t\t\t'F7', 'F8', 'F9', 'F10', 'F11', 'F12'\n\t\t\t\t\t];\n\n\t\t\t\t\tif (event.ctrlKey || event.metaKey) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (event.altKey) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (blockedKeys.includes(event.key)) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tevent.stopPropagation();\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tdocument.addEventListener('keydown', keyboardBlocker, true);\n\t\t\t\tdocument.addEventListener('keyup', keyboardBlocker, true);\n\t\t\t\tdocument.addEventListener('keypress', keyboardBlocker, true);\n\t\t\t}\n\n\t\t\tfunction enableKeyboardActions() {\n\t\t\t\tif (keyboardBlocker) {\n\t\t\t\t\tdocument.removeEventListener('keydown', keyboardBlocker, true);\n\t\t\t\t\tdocument.removeEventListener('keyup', keyboardBlocker, true);\n\t\t\t\t\tdocument.removeEventListener('keypress', keyboardBlocker, true);\n\t\t\t\t\tkeyboardBlocker = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tdisableKeyboardActions();\n\n\t\t\twindow.exitStepFunction = () => closeCardAndOverlay();\n\n\t\t\tif (nextButton) nextButton.addEventListener('click', completeHandler);\n\t\t\tif (closeButton) closeButton.addEventListener('click', () => {\n\t\t\t\tnotifyJavaBackend(\"exit\");\n\t\t\t});\n\n\t\t\tfunction completeHandler() {\n\t\t\t\tnotifyJavaBackend(\"complete\");\n\t\t\t\tcloseCardAndOverlay();\n\t\t\t}\n\n\t\t\tif (!validationValue || validationValue.trim() === '') {\n\t\t\t\ttargetElement.removeEventListener('click', completeHandler);\n\t\t\t\ttargetElement.addEventListener('click', completeHandler, { once: true });\n\t\t\t} else {\n\t\t\t\tvar originalBorder = targetElement.style.border || '';\n\t\t\t\tvar originalBoxShadow = targetElement.style.boxShadow || '';\n\n\t\t\t\tvar showValidationSuccess = function() {\n\t\t\t\t\ttargetElement.style.border = '2px solid #22c55e';\n\t\t\t\t\ttargetElement.style.boxShadow = '0 0 8px rgba(34, 197, 94, 0.5)';\n\t\t\t\t\ttargetElement.style.transition = 'border 0.3s ease, box-shadow 0.3s ease';\n\t\t\t\t};\n\n\t\t\t\tvar showValidationError = function() {\n\t\t\t\t\ttargetElement.style.border = '2px solid #ef4444';\n\t\t\t\t\ttargetElement.style.boxShadow = '0 0 8px rgba(239, 68, 68, 0.5)';\n\t\t\t\t\ttargetElement.style.transition = 'border 0.3s ease, box-shadow 0.3s ease';\n\t\t\t\t};\n\n\t\t\t\tvar removeValidationHighlight = function() {\n\t\t\t\t\ttargetElement.style.border = originalBorder;\n\t\t\t\t\ttargetElement.style.boxShadow = originalBoxShadow;\n\t\t\t\t};\n\n\t\t\t\tvar checkAndComplete = function() {\n\t\t\t\t\tvar value = '';\n\t\t\t\t\tif (targetElement.tagName === 'INPUT' || targetElement.tagName === 'TEXTAREA') {\n\t\t\t\t\t\tvalue = targetElement.value;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tvalue = targetElement.textContent;\n\t\t\t\t\t}\n\n\t\t\t\t\tif (value === validationValue) {\n\t\t\t\t\t\tremoveValidationHighlight();\n\t\t\t\t\t\tcompleteHandler();\n\t\t\t\t\t\tif (targetElement.removeEventListener) {\n\t\t\t\t\t\t\ttargetElement.removeEventListener('input', checkAndComplete);\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if (value.length === 0) {\n\t\t\t\t\t\tremoveValidationHighlight();\n\t\t\t\t\t} else if (validationValue.startsWith(value)) {\n\t\t\t\t\t\tshowValidationSuccess();\n\t\t\t\t\t} else {\n\t\t\t\t\t\tshowValidationError();\n\t\t\t\t\t}\n\t\t\t\t};\n\n\t\t\t\tif (targetElement.tagName === 'INPUT' || targetElement.tagName === 'TEXTAREA') {\n\t\t\t\t\ttargetElement.addEventListener('input', checkAndComplete);\n\t\t\t\t} else {\n\t\t\t\t\ttargetElement.addEventListener('input', checkAndComplete);\n\t\t\t\t\tvar observer = new MutationObserver(checkAndComplete);\n\t\t\t\t\tobserver.observe(targetElement, {\n\t\t\t\t\t\tchildList: true,\n\t\t\t\t\t\tcharacterData: true,\n\t\t\t\t\t\tsubtree: true\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tsetTimeout(function() {\n\t\t\t\t\ttry {\n\t\t\t\t\t\ttargetElement.focus();\n\n\t\t\t\t\t\tif (targetElement.tagName === 'INPUT' || targetElement.tagName === 'TEXTAREA') {\n\t\t\t\t\t\t\tvar textLength = targetElement.value.length;\n\t\t\t\t\t\t\ttargetElement.setSelectionRange(textLength, textLength);\n\t\t\t\t\t\t\ttargetElement.focus();\n\t\t\t\t\t\t\ttargetElement.click();\n\t\t\t\t\t\t} else if (targetElement.contentEditable === 'true' || targetElement.hasAttribute('contenteditable')) {\n\t\t\t\t\t\t\ttargetElement.focus();\n\n\t\t\t\t\t\t\tvar range = document.createRange();\n\t\t\t\t\t\t\tvar selection = window.getSelection();\n\t\t\t\t\t\t\trange.selectNodeContents(targetElement);\n\t\t\t\t\t\t\trange.collapse(false);\n\t\t\t\t\t\t\tselection.removeAllRanges();\n\t\t\t\t\t\t\tselection.addRange(range);\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tsetTimeout(function() {\n\t\t\t\t\t\t\tif (!targetElement.matches(':focus')) {\n\t\t\t\t\t\t\t\ttargetElement.focus();\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}, 100);\n\n\t\t\t\t\t} catch (error) {\n\t\t\t\t\t\tconsole.warn('Could not auto-focus validation element:', error);\n\t\t\t\t\t}\n\t\t\t\t}, 200);\n\t\t\t}\n\n\t\t} catch (error) {\n\t\t\tconsole.error(\"Failed to show popover:\", error.message);\n\t\t\treturn;\n\t\t}\n\t}\n";
        String selectorTypeStr = "";
        switch (this.selectorType) {
            case ID: {
                selectorTypeStr = "id";
                break;
            }
            case CLASS_NAME: {
                selectorTypeStr = "class";
                break;
            }
            case CSS_SELECTOR: {
                selectorTypeStr = "selector";
            }
        }
        String executeScript = String.format("showPopover({\n    elementSelector: '%s',\n    selectorType: '%s',\n    location: '%s',\n    enableNextButton: %s,\n    description: '%s',\n    validationValue: '%s'\n});\n", this.elementSelector, selectorTypeStr, this.location.name(), this.enableNextButton ? "true" : "false", this.description.replace("'", "\\'"), this.validationValue.replace("'", "\\'"));
        return js + executeScript;
    }

    public static WebPopoverBuilder newPopover() {
        return new WebPopoverBuilder();
    }

    public static enum PopoverLocation {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }

    public static enum SelectorType {
        ID,
        CLASS_NAME,
        CSS_SELECTOR;

    }
}

