/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.presentation.popover;

import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.objectspy.core.InspectSession;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.domain.tour.StepHandler;
import com.kms.katalon.onboarding.domain.tour.WebStepHandler;
import com.kms.katalon.onboarding.presentation.dialog.TourCancellationDialog;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class WebPopoverHandler {
    public static InspectSession recordSession = null;
    private static TourCancellationDialog activeCancellationDialog = null;
    private static final int DEFAULT_PORT = 60611;
    private static final int DEFAULT_ANIMATION_TIMEOUT = 500;

    public static void run(WebStepHandler step) {
        try {
            int port = WebPopoverHandler.createPopover(step);
            WebDriver wd = recordSession.getWebDriver();
            String script = step.popoverBuilder.withPort(String.valueOf(port)).build();
            UITimeUtil.setTimeout(() -> {
                WebPopoverHandler.layoutRecordingScreen(wd);
                ((JavascriptExecutor)wd).executeScript(script, new Object[0]);
            }, (long)500L);
        }
        catch (IOException e) {
            step.error(e);
        }
    }

    public static void cleanup() {
        WebDriver wd = recordSession.getWebDriver();
        ((JavascriptExecutor)wd).executeScript("if (window.exitStepFunction) { window.exitStepFunction(); }", new Object[0]);
    }

    public static boolean isPortAvailable(int port) {
        block12: {
            Throwable throwable = null;
            Object var2_3 = null;
            ServerSocket ignored = new ServerSocket(port);
            try {
                ignored.setReuseAddress(true);
                if (ignored == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (ignored != null) {
                            ignored.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            ignored.close();
        }
        return true;
    }

    public static int createPopover(StepHandler step) throws IOException {
        int port = WebPopoverHandler.findAvailablePort();
        if (port == 0) {
            throw new IOException(OnboardingMessageConstants.ERROR_NO_AVAILABLE_PORT);
        }
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        server.createContext("/complete", exchange -> {
            if (WebPopoverHandler.setupCorsAndHandleOptions(exchange)) {
                return;
            }
            WebPopoverHandler.sendOkResponse(exchange);
            if (exchange.getRequestMethod().equalsIgnoreCase("POST")) {
                server.stop(0);
                step.completeStep();
            }
        });
        server.createContext("/exit", exchange -> {
            if (WebPopoverHandler.setupCorsAndHandleOptions(exchange)) {
                return;
            }
            WebPopoverHandler.sendOkResponse(exchange);
            if (exchange.getRequestMethod().equalsIgnoreCase("POST")) {
                Display.getDefault().asyncExec(() -> {
                    if (stepHandler.needConfirmDialogWhenClose && WebPopoverHandler.showTourCancellationDialog() == 0) {
                        WebPopoverHandler.focusBrowserWindow();
                        step.resumeStep();
                    } else {
                        WebPopoverHandler.exitTourAndStopServer(step, server);
                    }
                });
            }
        });
        server.setExecutor(null);
        server.start();
        return port;
    }

    public static int showTourCancellationDialog() {
        if (activeCancellationDialog != null && !activeCancellationDialog.getShell().isDisposed()) {
            activeCancellationDialog.getShell().forceActive();
            return 0;
        }
        activeCancellationDialog = new TourCancellationDialog();
        int returnCode = activeCancellationDialog.open();
        activeCancellationDialog = null;
        return returnCode;
    }

    private static boolean setupCorsAndHandleOptions(HttpExchange exchange) throws IOException {
        exchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        exchange.getResponseHeaders().add("Access-Control-Allow-Methods", "POST, OPTIONS");
        exchange.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type,Authorization");
        if (exchange.getRequestMethod().equalsIgnoreCase("OPTIONS")) {
            exchange.sendResponseHeaders(204, -1L);
            return true;
        }
        return false;
    }

    private static void sendOkResponse(HttpExchange exchange) throws IOException {
        String response = "OK";
        exchange.sendResponseHeaders(200, response.length());
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream os = exchange.getResponseBody();){
            os.write(response.getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static int findAvailablePort() {
        return WebPopoverHandler.findAvailablePort(60611, 100);
    }

    private static int findAvailablePort(int defaultPort, int maxAttempts) {
        int i = 0;
        while (i < maxAttempts) {
            int candidatePort = defaultPort + i;
            if (WebPopoverHandler.isPortAvailable(candidatePort)) {
                return candidatePort;
            }
            ++i;
        }
        return 0;
    }

    public static void layoutRecordingScreen(WebDriver webDriver) {
        if (webDriver == null || !(webDriver instanceof WebDriver)) {
            return;
        }
        Rectangle currentBounds = WebPopoverHandler.getCurrentBrowserBounds(webDriver);
        Monitor currentMonitor = WebPopoverHandler.findMonitorContaining(currentBounds);
        Rectangle monitorBounds = currentMonitor.getBounds();
        int browserWidth = monitorBounds.width * 55 / 100;
        int browserHeight = monitorBounds.height;
        Point seleniumPoint = new Point(monitorBounds.x, monitorBounds.y);
        Dimension seleniumDimension = new Dimension(browserWidth, browserHeight);
        webDriver.manage().window().setPosition(seleniumPoint);
        webDriver.manage().window().setSize(seleniumDimension);
        WebPopoverHandler.resizeWebRecorderDialog(monitorBounds);
    }

    private static void resizeWebRecorderDialog(Rectangle monitorBounds) {
        Shell recorderDialog = ShellManager.getWebRecorderDialog();
        if (recorderDialog != null && !recorderDialog.isDisposed()) {
            int dialogWidth = monitorBounds.width * 45 / 100;
            int dialogHeight = monitorBounds.height;
            int dialogX = monitorBounds.x + monitorBounds.width * 55 / 100;
            int dialogY = monitorBounds.y;
            recorderDialog.setBounds(dialogX, dialogY, dialogWidth, dialogHeight);
        }
    }

    private static Rectangle getCurrentBrowserBounds(WebDriver webDriver) {
        try {
            Point position = webDriver.manage().window().getPosition();
            Dimension size = webDriver.manage().window().getSize();
            return new Rectangle(position.x, position.y, size.width, size.height);
        }
        catch (Exception exception) {
            return Display.getCurrent().getPrimaryMonitor().getBounds();
        }
    }

    private static Monitor findMonitorContaining(Rectangle bounds) {
        Monitor[] monitors = Display.getCurrent().getMonitors();
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            if (monitor.getBounds().contains(centerX, centerY)) {
                return monitor;
            }
            ++n2;
        }
        return Display.getCurrent().getPrimaryMonitor();
    }

    private static void exitTourAndStopServer(StepHandler step, HttpServer server) {
        step.exitStep();
        WebPopoverHandler.cleanup();
        server.stop(0);
    }

    private static void focusBrowserWindow() {
        WebDriver wd = recordSession.getWebDriver();
        if (wd != null) {
            ((JavascriptExecutor)wd).executeScript("window.focus();", new Object[0]);
        }
    }
}

