/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.project;

import com.kms.katalon.composer.project.sample.CloneSampleProjectRequest;
import com.kms.katalon.composer.project.sample.service.ICloneSampleProjectManager;
import com.kms.katalon.composer.project.sample.service.RemoteCloneWithLocalFallbackManager;
import com.kms.katalon.composer.project.template.SampleProjectProvider;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.internal.NamingUtil;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.project.IOnboardingProjectManager;
import com.kms.katalon.onboarding.project.OnboardingProjectType;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class OnboardingProjectManager
implements IOnboardingProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(OnboardingProjectManager.class);
    private static final String SAMPLE_LOCAL_TEST_SUITE_RESOURCE_NAME = OnboardingMessageConstants.ONBOARDING_LOCAL_TEST_SUITE_LOCAL_RESOURCE;
    private static final String SAMPLE_REMOTE_TEST_SUITE_REPO_URL = OnboardingMessageConstants.ONBOARDING_REMOTE_TEST_SUITE_REPO_URL;
    private static final String SAMPLE_REMOTE_TEST_SUITE_BRANCH = OnboardingMessageConstants.ONBOARDING_REMOTE_TEST_SUITE_REPO_BRANCH;
    private static final int MAX_CLONE_RETRIES = 2;
    private static final int RETRY_DELAY_MS = 1000;
    @Inject
    private IEventBroker eventBroker;
    private final SampleProjectProvider sampleProjectProvider = SampleProjectProvider.getInstance();
    private volatile ICloneSampleProjectManager cloneSampleProjectManager;
    private EventHandler projectCreatedHandler;
    private EventHandler cloneFailureHandler;

    @PostConstruct
    private void subscribeToCloneProjectEvents() {
        if (this.eventBroker == null) {
            return;
        }
        this.projectCreatedHandler = this::handleProjectCreated;
        this.cloneFailureHandler = this::handleCloneFailure;
        this.eventBroker.subscribe("PROJECT/CREATED", this.projectCreatedHandler);
        this.eventBroker.subscribe("GIT/CLONE_FAILED", this.cloneFailureHandler);
    }

    @Override
    public void createOnboardingProject(String tourId) throws Exception {
        OnboardingProjectType onboardingType = OnboardingProjectType.fromTourId(tourId);
        String projectName = this.getProjectName(onboardingType);
        String projectLocation = new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION, projectName).getAbsolutePath();
        if (onboardingType.requiresCloning()) {
            this.cloneOnboardingSampleProject(onboardingType, projectName, projectLocation);
        } else {
            this.createOnboardingSampleProject(onboardingType, projectName, projectLocation);
        }
    }

    private void createOnboardingSampleProject(OnboardingProjectType onboardingProjectType, String projectName, String projectLocation) throws Exception {
        this.sampleProjectProvider.createFirstOnboardingSampleProject(onboardingProjectType.getQuickStartProjectType(), projectName, projectLocation);
    }

    private void cloneOnboardingSampleProject(OnboardingProjectType onboardingProjectType, String projectName, String projectLocation) throws Exception {
        CloneSampleProjectRequest cloneRequest = this.createCloneRequest(onboardingProjectType, projectLocation, projectName);
        switch (onboardingProjectType) {
            case TEST_SUITE_EXECUTION: {
                this.cloneSampleProjectManager = new RemoteCloneWithLocalFallbackManager(cloneRequest, this.sampleProjectProvider, 2, 1000);
                break;
            }
            default: {
                logger.error(MessageFormat.format(OnboardingMessageConstants.ERROR_ONBOARDING_PROJECT_TYPE_NOT_SUPPORT, new Object[]{onboardingProjectType}));
                throw new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_ONBOARDING_PROJECT_TYPE_NOT_SUPPORT, new Object[]{onboardingProjectType}));
            }
        }
        this.cloneSampleProjectManager.startCloneProcess();
    }

    private void handleProjectCreated(Event event) {
        if (this.cloneSampleProjectManager != null) {
            this.cloneSampleProjectManager.handleProjectCreated(event);
        }
    }

    private void handleCloneFailure(Event event) {
        if (this.cloneSampleProjectManager != null) {
            this.cloneSampleProjectManager.handleCloneFailure(event);
        }
    }

    private String getProjectName(OnboardingProjectType onboardingType) {
        String projectName = onboardingType.getProjectNamePrefix();
        File firstProjectFolder = new File(GlobalStringConstants.DEFAULT_PROJECT_LOCATION);
        firstProjectFolder.mkdirs();
        return NamingUtil.getUniqueFileName((String)projectName, (String)firstProjectFolder.getAbsolutePath());
    }

    private CloneSampleProjectRequest createCloneRequest(OnboardingProjectType onboardingType, String projectLocation, String projectName) throws Exception {
        switch (onboardingType) {
            case TEST_SUITE_EXECUTION: {
                return new CloneSampleProjectRequest(onboardingType.getQuickStartProjectType(), projectLocation, projectName, SAMPLE_REMOTE_TEST_SUITE_REPO_URL, SAMPLE_REMOTE_TEST_SUITE_BRANCH, SAMPLE_LOCAL_TEST_SUITE_RESOURCE_NAME);
            }
        }
        logger.error(MessageFormat.format(OnboardingMessageConstants.ERROR_ONBOARDING_PROJECT_TYPE_NOT_SUPPORT, new Object[]{onboardingType}));
        throw new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_ONBOARDING_PROJECT_TYPE_NOT_SUPPORT, new Object[]{onboardingType}));
    }

    @PreDestroy
    public void dispose() {
        if (this.eventBroker != null) {
            if (this.projectCreatedHandler != null) {
                this.eventBroker.unsubscribe(this.projectCreatedHandler);
            }
            if (this.cloneFailureHandler != null) {
                this.eventBroker.unsubscribe(this.cloneFailureHandler);
            }
        }
        this.cloneSampleProjectManager = null;
    }
}

