/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.project;

import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourItem;

public enum OnboardingProjectType {
    WEB_RECORDING(OnboardingTourItem.WEB_RECORDING_TOUR.getTourId(), "Web Recording", QuickStartProjectType.WEBUI),
    TEST_SUITE_EXECUTION(OnboardingTourItem.TEST_SUITE_EXECUTOR_TOUR.getTourId(), "Test Suite Execution", QuickStartProjectType.WEBUI);

    private final String tourId;
    private final String displayName;
    private final QuickStartProjectType quickStartProjectType;

    private OnboardingProjectType(String tourId, String displayName, QuickStartProjectType quickStartProjectType) {
        this.tourId = tourId;
        this.displayName = displayName;
        this.quickStartProjectType = quickStartProjectType;
    }

    public String getTourId() {
        return this.tourId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public QuickStartProjectType getQuickStartProjectType() {
        return this.quickStartProjectType;
    }

    public static OnboardingProjectType fromTourId(String tourId) {
        OnboardingProjectType[] onboardingProjectTypeArray = OnboardingProjectType.values();
        int n = onboardingProjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OnboardingProjectType type = onboardingProjectTypeArray[n2];
            if (type.getTourId().equals(tourId)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown tour ID: " + tourId);
    }

    public boolean requiresCloning() {
        return this == TEST_SUITE_EXECUTION;
    }

    public String getProjectNamePrefix() {
        switch (this) {
            case WEB_RECORDING: {
                return "My First Web Recording Project";
            }
            case TEST_SUITE_EXECUTION: {
                return "My First Test Suite Project";
            }
        }
        return "My First Onboarding Project";
    }
}

