/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.plugins;

import io.cucumber.eclipse.java.plugins.CucumberEclipsePlugin;
import io.cucumber.eclipse.java.plugins.Jackson;
import io.cucumber.messages.types.Envelope;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;

public abstract class MessageEndpoint {
    private ServerSocket serverSocket = new ServerSocket(0);

    private void closeSocket(ServerSocket serverSocket) {
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void handleMessage(Envelope var1) throws InterruptedException;

    public void start() {
        Thread thread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    try {
                        Socket socket;
                        block28: {
                            socket = MessageEndpoint.this.serverSocket.accept();
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try {
                                DataInputStream inputStream = new DataInputStream(socket.getInputStream());
                                try {
                                    try (OutputStream outputStream = socket.getOutputStream();){
                                        int framelength;
                                        byte[] buffer = new byte[0xA00000];
                                        while ((framelength = inputStream.readInt()) > 0) {
                                            if (buffer.length < framelength) {
                                                buffer = new byte[framelength];
                                            }
                                            inputStream.readFully(buffer, 0, framelength);
                                            Envelope envelope = (Envelope)Jackson.OBJECT_MAPPER.readerFor(Envelope.class).readValue(buffer, 0, framelength);
                                            try {
                                                MessageEndpoint.this.handleMessage(envelope);
                                            }
                                            catch (InterruptedException e) {
                                                break;
                                            }
                                            outputStream.write(1);
                                            outputStream.flush();
                                            if (!envelope.getTestRunFinished().isPresent()) continue;
                                        }
                                        outputStream.write(0);
                                        outputStream.flush();
                                    }
                                    if (inputStream == null) break block28;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (inputStream == null) throw throwable;
                                    inputStream.close();
                                    throw throwable;
                                }
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                        socket.close();
                        return;
                    }
                    catch (IOException iOException) {
                        try {
                            MessageEndpoint.this.serverSocket.close();
                            return;
                        }
                        catch (IOException iOException2) {
                            return;
                        }
                    }
                }
                finally {
                    try {
                        MessageEndpoint.this.serverSocket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public void addArguments(Collection<String> args) {
        args.add("-p");
        args.add(CucumberEclipsePlugin.class.getName() + ":" + String.valueOf(this.serverSocket.getLocalPort()));
    }

    public boolean isTerminated() {
        return this.serverSocket.isClosed();
    }

    public void terminate() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

