/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXContainerItemProxy
implements Comparable<PBXContainerItemProxy> {
    private CommentedIdentifier reference;
    private String isa;
    private CommentedIdentifier containerPortal;
    private Integer proxyType;
    private String remoteGlobalIDString;
    private String remoteInfo;

    public PBXContainerItemProxy(String containerItemProxyString) throws InvalidObjectFormatException {
        try {
            containerItemProxyString = containerItemProxyString.trim();
            int equalsIndex = containerItemProxyString.indexOf(61);
            String commentPart = "";
            String uuidPart = containerItemProxyString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = containerItemProxyString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(containerItemProxyString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("containerPortal")) {
                    this.containerPortal = parser.getCommentedIdentifier(value);
                } else if (key.equals("proxyType")) {
                    this.proxyType = Integer.valueOf(value);
                } else if (key.equals("remoteGlobalIDString")) {
                    this.remoteGlobalIDString = value;
                } else if (key.equals("remoteInfo")) {
                    this.remoteInfo = value;
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        returnString = returnString + tabString + "\tcontainerPortal = " + this.containerPortal.toString() + ";\n";
        returnString = returnString + tabString + "\tproxyType = " + this.proxyType + ";\n";
        returnString = returnString + tabString + "\tremoteGlobalIDString = " + this.remoteGlobalIDString + ";\n";
        returnString = returnString + tabString + "\tremoteInfo = " + this.remoteInfo + ";\n";
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(PBXContainerItemProxy o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public CommentedIdentifier getContainerPortal() {
        return this.containerPortal;
    }

    public Integer getProxyType() {
        return this.proxyType;
    }

    public String getRemoteGlobalIDString() {
        return this.remoteGlobalIDString;
    }

    public String getRemoteInfo() {
        return this.remoteInfo;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setContainerPortal(CommentedIdentifier containerPortal) {
        this.containerPortal = containerPortal;
    }

    public void setProxyType(Integer proxyType) {
        this.proxyType = proxyType;
    }

    public void setRemoteGlobalIDString(String remoteGlobalIDString) {
        this.remoteGlobalIDString = remoteGlobalIDString;
    }

    public void setRemoteInfo(String remoteInfo) {
        this.remoteInfo = remoteInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PBXContainerItemProxy)) {
            return false;
        }
        PBXContainerItemProxy other = (PBXContainerItemProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        CommentedIdentifier this$containerPortal = this.getContainerPortal();
        CommentedIdentifier other$containerPortal = other.getContainerPortal();
        if (this$containerPortal == null ? other$containerPortal != null : !((Object)this$containerPortal).equals(other$containerPortal)) {
            return false;
        }
        Integer this$proxyType = this.getProxyType();
        Integer other$proxyType = other.getProxyType();
        if (this$proxyType == null ? other$proxyType != null : !((Object)this$proxyType).equals(other$proxyType)) {
            return false;
        }
        String this$remoteGlobalIDString = this.getRemoteGlobalIDString();
        String other$remoteGlobalIDString = other.getRemoteGlobalIDString();
        if (this$remoteGlobalIDString == null ? other$remoteGlobalIDString != null : !this$remoteGlobalIDString.equals(other$remoteGlobalIDString)) {
            return false;
        }
        String this$remoteInfo = this.getRemoteInfo();
        String other$remoteInfo = other.getRemoteInfo();
        return !(this$remoteInfo == null ? other$remoteInfo != null : !this$remoteInfo.equals(other$remoteInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PBXContainerItemProxy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        CommentedIdentifier $containerPortal = this.getContainerPortal();
        result = result * 59 + ($containerPortal == null ? 0 : ((Object)$containerPortal).hashCode());
        Integer $proxyType = this.getProxyType();
        result = result * 59 + ($proxyType == null ? 0 : ((Object)$proxyType).hashCode());
        String $remoteGlobalIDString = this.getRemoteGlobalIDString();
        result = result * 59 + ($remoteGlobalIDString == null ? 0 : $remoteGlobalIDString.hashCode());
        String $remoteInfo = this.getRemoteInfo();
        result = result * 59 + ($remoteInfo == null ? 0 : $remoteInfo.hashCode());
        return result;
    }

    public PBXContainerItemProxy() {
    }

    @ConstructorProperties(value={"reference", "isa", "containerPortal", "proxyType", "remoteGlobalIDString", "remoteInfo"})
    public PBXContainerItemProxy(CommentedIdentifier reference, String isa, CommentedIdentifier containerPortal, Integer proxyType, String remoteGlobalIDString, String remoteInfo) {
        this.reference = reference;
        this.isa = isa;
        this.containerPortal = containerPortal;
        this.proxyType = proxyType;
        this.remoteGlobalIDString = remoteGlobalIDString;
        this.remoteInfo = remoteInfo;
    }
}

