/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.models;

import ca.mestevens.ios.xcode.parser.exceptions.InvalidObjectFormatException;
import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import ca.mestevens.ios.xcode.parser.utils.ObjectParser;
import java.beans.ConstructorProperties;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBXTarget
implements Comparable<PBXTarget> {
    private CommentedIdentifier reference;
    private String isa;
    private CommentedIdentifier buildConfigurationList;
    private List<CommentedIdentifier> buildPhases;
    private List<CommentedIdentifier> buildRules;
    private List<CommentedIdentifier> dependencies;
    private String name;
    private String productName;
    private String productInstallPath;
    private CommentedIdentifier productReference;
    private String productType;

    public PBXTarget(String targetString) throws InvalidObjectFormatException {
        try {
            targetString = targetString.trim();
            int equalsIndex = targetString.indexOf(61);
            String commentPart = "";
            String uuidPart = targetString.substring(0, equalsIndex).trim();
            if (uuidPart.contains("/*")) {
                int commentStartIndex = uuidPart.indexOf("/*");
                int commentEndIndex = uuidPart.indexOf("*/");
                commentPart = targetString.substring(commentStartIndex + 2, commentEndIndex).trim();
                uuidPart = uuidPart.substring(0, commentStartIndex).trim();
            }
            this.reference = new CommentedIdentifier(uuidPart, commentPart);
            ObjectParser parser = new ObjectParser(targetString);
            parser = parser.getNextNestedObjects();
            String parserObject = parser.parseNextObject();
            while (parserObject != null && !parserObject.equals("")) {
                parserObject = parserObject.substring(0, parserObject.length() - 1);
                String[] splitObject = parserObject.split("=");
                String key = splitObject[0].trim();
                String value = "";
                for (int i = 1; i < splitObject.length; ++i) {
                    if (i > 1) {
                        value = value + "=";
                    }
                    value = value + splitObject[i];
                }
                value = value.trim();
                if (key.equals("isa")) {
                    this.isa = value;
                } else if (key.equals("buildConfigurationList")) {
                    this.buildConfigurationList = parser.getCommentedIdentifier(value);
                } else if (key.equals("buildPhases")) {
                    this.buildPhases = parser.getIdentifierList(value);
                } else if (key.equals("dependencies")) {
                    this.dependencies = parser.getIdentifierList(value);
                } else if (key.equals("name")) {
                    this.name = value;
                } else if (key.equals("productName")) {
                    this.productName = value;
                } else if (key.equals("productInstallPath")) {
                    this.productInstallPath = value;
                } else if (key.equals("productReference")) {
                    this.productReference = parser.getCommentedIdentifier(value);
                } else if (key.equals("productType")) {
                    this.productType = value;
                } else if (key.equals("buildRules")) {
                    this.buildRules = parser.getIdentifierList(value);
                }
                parserObject = parser.parseNextObject();
            }
        }
        catch (Exception ex) {
            throw new InvalidObjectFormatException(ex);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int numberOfTabs) {
        String tabString = "";
        for (int i = 0; i < numberOfTabs; ++i) {
            tabString = tabString + "\t";
        }
        String returnString = "";
        returnString = returnString + tabString + this.reference.toString() + " = {\n";
        returnString = returnString + tabString + "\tisa = " + this.isa + ";\n";
        returnString = returnString + tabString + "\tbuildConfigurationList = " + this.buildConfigurationList.toString() + ";\n";
        returnString = returnString + tabString + "\tbuildPhases = (\n";
        for (CommentedIdentifier buildPhase : this.buildPhases) {
            returnString = returnString + tabString + "\t\t" + buildPhase.toString() + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        returnString = returnString + tabString + "\tbuildRules = (\n";
        for (CommentedIdentifier rule : this.buildRules) {
            returnString = returnString + tabString + "\t\t" + rule.toString() + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        returnString = returnString + tabString + "\tdependencies = (\n";
        for (CommentedIdentifier dependency : this.dependencies) {
            returnString = returnString + tabString + "\t\t" + dependency.toString() + ",\n";
        }
        returnString = returnString + tabString + "\t);\n";
        returnString = returnString + tabString + "\tname = " + this.name + ";\n";
        returnString = returnString + tabString + "\tproductName = " + this.productName + ";\n";
        if (this.productInstallPath != null) {
            returnString = returnString + tabString + "\tproductInstallPath = " + this.productInstallPath + ";\n";
        }
        if (this.productReference != null) {
            returnString = returnString + tabString + "\tproductReference = " + this.productReference.toString() + ";\n";
        }
        if (this.productType != null) {
            returnString = returnString + tabString + "\tproductType = " + this.productType + ";\n";
        }
        returnString = returnString + tabString + "};";
        return returnString;
    }

    @Override
    public int compareTo(PBXTarget o) {
        return this.reference.getIdentifier().compareTo(o.getReference().getIdentifier());
    }

    public CommentedIdentifier getReference() {
        return this.reference;
    }

    public String getIsa() {
        return this.isa;
    }

    public CommentedIdentifier getBuildConfigurationList() {
        return this.buildConfigurationList;
    }

    public List<CommentedIdentifier> getBuildPhases() {
        return this.buildPhases;
    }

    public List<CommentedIdentifier> getBuildRules() {
        return this.buildRules;
    }

    public List<CommentedIdentifier> getDependencies() {
        return this.dependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductInstallPath() {
        return this.productInstallPath;
    }

    public CommentedIdentifier getProductReference() {
        return this.productReference;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setReference(CommentedIdentifier reference) {
        this.reference = reference;
    }

    public void setIsa(String isa) {
        this.isa = isa;
    }

    public void setBuildConfigurationList(CommentedIdentifier buildConfigurationList) {
        this.buildConfigurationList = buildConfigurationList;
    }

    public void setBuildPhases(List<CommentedIdentifier> buildPhases) {
        this.buildPhases = buildPhases;
    }

    public void setBuildRules(List<CommentedIdentifier> buildRules) {
        this.buildRules = buildRules;
    }

    public void setDependencies(List<CommentedIdentifier> dependencies) {
        this.dependencies = dependencies;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setProductInstallPath(String productInstallPath) {
        this.productInstallPath = productInstallPath;
    }

    public void setProductReference(CommentedIdentifier productReference) {
        this.productReference = productReference;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PBXTarget)) {
            return false;
        }
        PBXTarget other = (PBXTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommentedIdentifier this$reference = this.getReference();
        CommentedIdentifier other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !((Object)this$reference).equals(other$reference)) {
            return false;
        }
        String this$isa = this.getIsa();
        String other$isa = other.getIsa();
        if (this$isa == null ? other$isa != null : !this$isa.equals(other$isa)) {
            return false;
        }
        CommentedIdentifier this$buildConfigurationList = this.getBuildConfigurationList();
        CommentedIdentifier other$buildConfigurationList = other.getBuildConfigurationList();
        if (this$buildConfigurationList == null ? other$buildConfigurationList != null : !((Object)this$buildConfigurationList).equals(other$buildConfigurationList)) {
            return false;
        }
        List<CommentedIdentifier> this$buildPhases = this.getBuildPhases();
        List<CommentedIdentifier> other$buildPhases = other.getBuildPhases();
        if (this$buildPhases == null ? other$buildPhases != null : !((Object)this$buildPhases).equals(other$buildPhases)) {
            return false;
        }
        List<CommentedIdentifier> this$buildRules = this.getBuildRules();
        List<CommentedIdentifier> other$buildRules = other.getBuildRules();
        if (this$buildRules == null ? other$buildRules != null : !((Object)this$buildRules).equals(other$buildRules)) {
            return false;
        }
        List<CommentedIdentifier> this$dependencies = this.getDependencies();
        List<CommentedIdentifier> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$productInstallPath = this.getProductInstallPath();
        String other$productInstallPath = other.getProductInstallPath();
        if (this$productInstallPath == null ? other$productInstallPath != null : !this$productInstallPath.equals(other$productInstallPath)) {
            return false;
        }
        CommentedIdentifier this$productReference = this.getProductReference();
        CommentedIdentifier other$productReference = other.getProductReference();
        if (this$productReference == null ? other$productReference != null : !((Object)this$productReference).equals(other$productReference)) {
            return false;
        }
        String this$productType = this.getProductType();
        String other$productType = other.getProductType();
        return !(this$productType == null ? other$productType != null : !this$productType.equals(other$productType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PBXTarget;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommentedIdentifier $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : ((Object)$reference).hashCode());
        String $isa = this.getIsa();
        result = result * 59 + ($isa == null ? 0 : $isa.hashCode());
        CommentedIdentifier $buildConfigurationList = this.getBuildConfigurationList();
        result = result * 59 + ($buildConfigurationList == null ? 0 : ((Object)$buildConfigurationList).hashCode());
        List<CommentedIdentifier> $buildPhases = this.getBuildPhases();
        result = result * 59 + ($buildPhases == null ? 0 : ((Object)$buildPhases).hashCode());
        List<CommentedIdentifier> $buildRules = this.getBuildRules();
        result = result * 59 + ($buildRules == null ? 0 : ((Object)$buildRules).hashCode());
        List<CommentedIdentifier> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 0 : ((Object)$dependencies).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 0 : $productName.hashCode());
        String $productInstallPath = this.getProductInstallPath();
        result = result * 59 + ($productInstallPath == null ? 0 : $productInstallPath.hashCode());
        CommentedIdentifier $productReference = this.getProductReference();
        result = result * 59 + ($productReference == null ? 0 : ((Object)$productReference).hashCode());
        String $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 0 : $productType.hashCode());
        return result;
    }

    public PBXTarget() {
    }

    @ConstructorProperties(value={"reference", "isa", "buildConfigurationList", "buildPhases", "buildRules", "dependencies", "name", "productName", "productInstallPath", "productReference", "productType"})
    public PBXTarget(CommentedIdentifier reference, String isa, CommentedIdentifier buildConfigurationList, List<CommentedIdentifier> buildPhases, List<CommentedIdentifier> buildRules, List<CommentedIdentifier> dependencies, String name, String productName, String productInstallPath, CommentedIdentifier productReference, String productType) {
        this.reference = reference;
        this.isa = isa;
        this.buildConfigurationList = buildConfigurationList;
        this.buildPhases = buildPhases;
        this.buildRules = buildRules;
        this.dependencies = dependencies;
        this.name = name;
        this.productName = productName;
        this.productInstallPath = productInstallPath;
        this.productReference = productReference;
        this.productType = productType;
    }
}

