/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.custom.dialog;

import com.katalon.capability.composer.custom.dialog.CapabilityBuilderDialog;
import com.katalon.capability.composer.custom.dialog.MobileCapabilityBuilderDialog;
import com.katalon.capability.composer.custom.dialog.RemoteCapabilityBuilderDialog;
import com.katalon.capability.composer.custom.dialog.WebUiCapabilityBuilderDialog;
import com.katalon.capability.composer.custom.dialog.WindowsCapabilityBuilderDialog;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.model.CapabilitySetting;
import org.eclipse.swt.widgets.Shell;

public class CapabilityBuilderDialogFactory {
    public static CapabilityBuilderDialog createCapabilityBuilderDialog(Shell shell, CapabilitySetting capabilitySetting) throws UnsupportedDriverTypeException {
        DriverType driverType = capabilitySetting.getDriverType();
        return switch (driverType) {
            case DriverType.CHROME_DRIVER, DriverType.FIREFOX_DRIVER, DriverType.EDGE_CHROMIUM_DRIVER, DriverType.SAFARI_DRIVER, DriverType.HEADLESS_DRIVER, DriverType.FIREFOX_HEADLESS_DRIVER -> new WebUiCapabilityBuilderDialog(shell, capabilitySetting);
            case DriverType.ANDROID_DRIVER, DriverType.IOS_DRIVER -> new MobileCapabilityBuilderDialog(shell, capabilitySetting);
            case DriverType.WINDOWS_DRIVER -> new WindowsCapabilityBuilderDialog(shell, capabilitySetting);
            case DriverType.REMOTE_WEB_DRIVER -> new RemoteCapabilityBuilderDialog(shell, capabilitySetting);
            default -> throw new UnsupportedDriverTypeException("Unsupported driver type: " + String.valueOf(driverType));
        };
    }
}

