/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.mobile.component;

import com.katalon.capability.composer.mobile.util.MobileDeviceUIProvider;
import com.katalon.capability.constant.DriverType;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.execution.mobile.configuration.providers.MobileDeviceProvider;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.exception.MobileSetupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceSelectionComposite
extends Composite {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceSelectionComposite.class);
    private Combo cbbDevices;
    private List<MobileDeviceInfo> devicesList = new ArrayList<MobileDeviceInfo>();
    private Integer selectedDeviceIndex;

    public DeviceSelectionComposite(Composite parent, int style, DriverType platform) {
        super(parent, style);
        this.setBackground(ColorUtil.getCompositeBackgroundColorForDialog());
        this.setBackgroundMode(2);
        this.setLayoutData(new GridData(1808));
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        this.setLayout((Layout)glContainer);
        this.loadDeviceList(platform);
        Label theLabel = new Label((Composite)this, 0);
        theLabel.setText("Device Name:");
        this.cbbDevices = new Combo((Composite)this, 4);
        this.cbbDevices.setLayoutData((Object)new GridData(768));
        this.cbbDevices.setItems(this.getDeviceFullNames());
        this.cbbDevices.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceSelectionComposite.this.selectedDeviceIndex = DeviceSelectionComposite.this.cbbDevices.getSelectionIndex();
            }
        });
        this.cbbDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceSelectionComposite.this.selectedDeviceIndex = DeviceSelectionComposite.this.cbbDevices.getSelectionIndex();
            }
        });
    }

    private String[] getDeviceFullNames() {
        String[] fullNames = new String[this.devicesList.size()];
        int i = 0;
        while (i < this.devicesList.size()) {
            fullNames[i] = this.devicesList.get(i).getDisplayName();
            ++i;
        }
        return fullNames;
    }

    public void setDeviceId(String deviceId) {
        int i = 0;
        while (i < this.devicesList.size()) {
            if (this.devicesList.get(i).getDeviceId().equals(deviceId)) {
                this.cbbDevices.select(i);
                return;
            }
            ++i;
        }
        this.cbbDevices.setItems(this.getDeviceFullNames());
        this.selectedDeviceIndex = this.cbbDevices.getSelectionIndex();
    }

    private void loadDeviceList(DriverType platForm) {
        this.devicesList.clear();
        switch (platForm) {
            case ANDROID_DRIVER: {
                try {
                    if (!MobileDeviceUIProvider.checkAndroidSDKExist(this.getShell())) break;
                    this.devicesList.addAll(MobileDeviceProvider.getAndroidDevices());
                }
                catch (MobileSetupException | IOException | InterruptedException e) {
                    this.logException((Exception)e);
                }
                break;
            }
            case IOS_DRIVER: {
                try {
                    this.devicesList.addAll(MobileDeviceProvider.getIosDevices());
                }
                catch (IOException | InterruptedException e) {
                    this.logException(e);
                }
                try {
                    this.devicesList.addAll(MobileDeviceProvider.getIosSimulators());
                }
                catch (IOException | InterruptedException e) {
                    this.logException(e);
                }
                break;
            }
        }
    }

    public void logException(Exception e) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage()));
        LOGGER.error(e.getMessage(), (Throwable)e);
    }

    private boolean isNoDeviceSelected() {
        return this.devicesList.isEmpty() || this.selectedDeviceIndex == null || this.selectedDeviceIndex < 0;
    }

    public MobileDeviceInfo getSelectedDevice() {
        if (this.isNoDeviceSelected()) {
            return null;
        }
        return this.devicesList.get(this.selectedDeviceIndex);
    }
}

