/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.mobile.util;

import com.katalon.capability.composer.mobile.job.DownloadSDKProgress;
import com.kms.katalon.composer.components.dialogs.MessageDialogWithLink;
import com.kms.katalon.composer.components.services.CallabelUISynchronize;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.execution.mobile.configuration.providers.MobileDeviceProvider;
import com.kms.katalon.execution.mobile.device.AndroidSDKManager;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileDeviceUIProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileDeviceUIProvider.class);

    private MobileDeviceUIProvider() {
    }

    public static List<MobileDeviceInfo> getAndroidDevices() {
        ArrayList<MobileDeviceInfo> mobileDeviceInfos = new ArrayList<MobileDeviceInfo>();
        Shell activeShell = null;
        try {
            boolean sdkExists = (Boolean)CallabelUISynchronize.newInstance().syncCallabelExec(() -> MobileDeviceUIProvider.checkAndroidSDKExist(activeShell));
            if (sdkExists) {
                mobileDeviceInfos.addAll(MobileDeviceProvider.getAndroidDevices());
            }
        }
        catch (Exception e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return mobileDeviceInfos;
    }

    public static List<MobileDeviceInfo> getIOSDevices() {
        ArrayList<MobileDeviceInfo> mobileDeviceInfos = new ArrayList<MobileDeviceInfo>();
        Shell activeShell = null;
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosDevices());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosSimulators());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return mobileDeviceInfos;
    }

    public static List<MobileDeviceInfo> getAllDevices() {
        ArrayList<MobileDeviceInfo> mobileDeviceInfos = new ArrayList<MobileDeviceInfo>();
        Shell activeShell = null;
        try {
            boolean sdkExists = (Boolean)CallabelUISynchronize.newInstance().syncCallabelExec(() -> MobileDeviceUIProvider.checkAndroidSDKExist(activeShell));
            if (sdkExists) {
                mobileDeviceInfos.addAll(MobileDeviceProvider.getAndroidDevices());
            }
        }
        catch (Exception e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosDevices());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        try {
            mobileDeviceInfos.addAll(MobileDeviceProvider.getIosSimulators());
        }
        catch (IOException | InterruptedException e) {
            UISynchronizeService.syncExec(() -> MessageDialog.openInformation((Shell)activeShell, (String)"Error", (String)(e.getClass().getName() + ": " + e.getMessage())));
        }
        return mobileDeviceInfos;
    }

    public static boolean checkAndroidSDKExist(Shell activeShell) {
        AndroidSDKManager sdkManager = new AndroidSDKManager();
        if (!sdkManager.checkSDKExists()) {
            if (!MessageDialog.openConfirm((Shell)activeShell, (String)"Confirmation", (String)"Android SDK is missing. Do you want to download Android SDK?")) {
                return false;
            }
            return MobileDeviceUIProvider.newDownloadSDKProgress(activeShell, sdkManager);
        }
        return true;
    }

    public static boolean newDownloadSDKProgress(Shell activeShell, AndroidSDKManager sdkManager) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(activeShell);
        try {
            dialog.run(true, false, (IRunnableWithProgress)new DownloadSDKProgress(sdkManager.getSDKLocator()));
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            MessageDialogWithLink.openError((Shell)activeShell, (String)"Error", (String)e.getTargetException().getMessage());
            return false;
        }
    }
}

