/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.ssl.Certificates;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.TrustMaterial;

public class TrustChain {
    private final Set trustMaterial = Collections.synchronizedSet(new HashSet());
    private SortedSet x509Certificates = null;
    private KeyStore unifiedKeyStore = null;

    public synchronized KeyStore getUnifiedKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String alias;
        if (this.x509Certificates != null) {
            return this.unifiedKeyStore;
        }
        this.x509Certificates = new TreeSet(Certificates.COMPARE_BY_EXPIRY);
        for (TrustMaterial tm : this.trustMaterial) {
            KeyStore ks = tm.getKeyStore();
            if (ks == null) continue;
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                X509Certificate cert;
                alias = en.nextElement();
                if (!ks.isCertificateEntry(alias) || this.x509Certificates.contains(cert = (X509Certificate)ks.getCertificate(alias))) continue;
                this.x509Certificates.add(cert);
            }
        }
        Iterator it = this.x509Certificates.iterator();
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        int count = 0;
        while (it.hasNext()) {
            X509Certificate cert = (X509Certificate)it.next();
            alias = "commons-ssl-" + count;
            ks.setCertificateEntry(alias, cert);
            ++count;
        }
        this.unifiedKeyStore = ks;
        return this.unifiedKeyStore;
    }

    public synchronized void addTrustMaterial(TrustChain tc) {
        this.x509Certificates = null;
        if (tc instanceof TrustMaterial) {
            this.trustMaterial.add(tc);
        }
        this.trustMaterial.addAll(tc.trustMaterial);
    }

    public boolean contains(TrustChain tc) {
        if (tc instanceof TrustMaterial) {
            return this.trustMaterial.contains(tc);
        }
        return this.trustMaterial.containsAll(tc.trustMaterial);
    }

    public boolean contains(X509Certificate cert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return this.getCertificates().contains(cert);
    }

    public Object getTrustManagerFactory() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        KeyStore uks = this.getUnifiedKeyStore();
        if (uks != null) {
            return JavaImpl.newTrustManagerFactory(uks);
        }
        return null;
    }

    public Object[] getTrustManagers() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        Object tmf = this.getTrustManagerFactory();
        return tmf != null ? JavaImpl.getTrustManagers(tmf) : null;
    }

    public synchronized SortedSet getCertificates() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this.x509Certificates == null) {
            this.getUnifiedKeyStore();
        }
        return Collections.unmodifiableSortedSet(this.x509Certificates);
    }

    public synchronized int getSize() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return this.getCertificates().size();
    }

    public synchronized boolean isEmpty() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        return this.getCertificates().isEmpty();
    }

    protected boolean containsTrustAll() {
        for (TrustChain tc : this.trustMaterial) {
            if (tc == this || !tc.containsTrustAll()) continue;
            return true;
        }
        return false;
    }
}

