/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.artifact.dialog;

import com.katalon.platform.api.exception.PlatformException;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.model.ExecutionProfileEntity;
import com.katalon.platform.api.model.TestCaseEntity;
import com.katalon.platform.api.model.TestObjectEntity;
import com.katalon.platform.api.ui.DialogActionService;
import com.kms.katalon.composer.artifact.constant.ImageConstants;
import com.kms.katalon.composer.artifact.constant.StringConstants;
import com.kms.katalon.composer.artifact.core.util.PlatformUtil;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.keyword.dialogs.KeywordSelectionDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ExportTestArtifactDialog
extends Dialog {
    private List<TestCaseEntity> selectedTestCases = new ArrayList<TestCaseEntity>();
    private List<TestObjectEntity> selectedTestObjects = new ArrayList<TestObjectEntity>();
    private List<ExecutionProfileEntity> selectedProfiles = new ArrayList<ExecutionProfileEntity>();
    private List<File> selectedKeywords = new ArrayList<File>();
    private TableViewer testCaseTableViewer;
    private ToolItem btnAddTestCase;
    private ToolItem btnDeleteTestCase;
    private TableViewer testObjectTableViewer;
    private ToolItem btnAddTestObject;
    private ToolItem btnDeleteTestObject;
    private TableViewer profileTableViewer;
    private ToolItem btnAddProfile;
    private ToolItem btnDeleteProfile;
    private ToolItem btnAddKeyword;
    private ToolItem btnDeleteKeyword;
    private TableViewer keywordTableViewer;
    private Text txtExportLocation;
    private Button btnChooseExportFolder;
    private ExportTestArtifactDialogResult dialogResult;

    public ExportTestArtifactDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout glBody = new GridLayout(1, false);
        body.setLayout((Layout)glBody);
        GridData gdBody = new GridData(4, 4, true, true);
        gdBody.widthHint = 500;
        body.setLayoutData((Object)gdBody);
        this.createTestCaseSelectionSection(body);
        this.createTestObjectSelectionSection(body);
        this.createProfileSelectionSection(body);
        this.createKeywordSelectionSection(body);
        this.createExportLocationSection(body);
        this.registerControlListeners();
        return body;
    }

    private void createTestCaseSelectionSection(Composite parent) {
        Label lblTestCase = new Label(parent, 0);
        lblTestCase.setText(StringConstants.LBL_TEST_CASE);
        ToolBar toolBar = new ToolBar(parent, 8519744);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnAddTestCase = new ToolItem(toolBar, 0x800000);
        this.btnAddTestCase.setText(StringConstants.TOOL_ITEM_ADD);
        this.btnAddTestCase.setImage(ImageConstants.IMG_16_ADD);
        this.btnDeleteTestCase = new ToolItem(toolBar, 0x800000);
        this.btnDeleteTestCase.setText(StringConstants.TOOL_ITEM_DELETE);
        this.btnDeleteTestCase.setImage(ImageConstants.IMG_16_DELETE);
        this.btnDeleteTestCase.setEnabled(false);
        Composite testCaseTableComposite = new Composite(parent, 0);
        GridData gdTestCaseTableComposite = new GridData(4, 4, true, true);
        gdTestCaseTableComposite.heightHint = 200;
        testCaseTableComposite.setLayoutData((Object)gdTestCaseTableComposite);
        testCaseTableComposite.setLayout((Layout)new FillLayout());
        this.testCaseTableViewer = new TableViewer(testCaseTableComposite, 2050);
        this.testCaseTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table testCaseTable = this.testCaseTableViewer.getTable();
        testCaseTable.setHeaderVisible(true);
        testCaseTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnTestCaseId = new TableViewerColumn(this.testCaseTableViewer, 16384);
        TableColumn tableColumnId = tableViewerColumnTestCaseId.getColumn();
        tableColumnId.setText(StringConstants.COL_TEST_CASE_ID);
        tableViewerColumnTestCaseId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TestCaseEntity testCase = (TestCaseEntity)element;
                return testCase.getId();
            }
        });
        TableColumnLayout testCaseTableLayout = new TableColumnLayout();
        testCaseTableLayout.setColumnData((Widget)tableColumnId, (ColumnLayoutData)new ColumnWeightData(100, 30));
        testCaseTableComposite.setLayout((Layout)testCaseTableLayout);
        this.testCaseTableViewer.setInput(this.selectedTestCases);
        this.testCaseTableViewer.refresh();
    }

    private void createTestObjectSelectionSection(Composite parent) {
        Label lblTestObject = new Label(parent, 0);
        lblTestObject.setText(StringConstants.LBL_TEST_OBJECT);
        ToolBar toolBar = new ToolBar(parent, 8519744);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnAddTestObject = new ToolItem(toolBar, 0x800000);
        this.btnAddTestObject.setText(StringConstants.TOOL_ITEM_ADD);
        this.btnAddTestObject.setImage(ImageConstants.IMG_16_ADD);
        this.btnDeleteTestObject = new ToolItem(toolBar, 0x800000);
        this.btnDeleteTestObject.setText(StringConstants.TOOL_ITEM_DELETE);
        this.btnDeleteTestObject.setImage(ImageConstants.IMG_16_DELETE);
        this.btnDeleteTestObject.setEnabled(false);
        Composite testObjectTableComposite = new Composite(parent, 0);
        GridData gdtestObjectTableComposite = new GridData(4, 4, true, true);
        gdtestObjectTableComposite.heightHint = 200;
        testObjectTableComposite.setLayoutData((Object)gdtestObjectTableComposite);
        testObjectTableComposite.setLayout((Layout)new FillLayout());
        this.testObjectTableViewer = new TableViewer(testObjectTableComposite, 2050);
        this.testObjectTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table testObjectTable = this.testObjectTableViewer.getTable();
        testObjectTable.setHeaderVisible(true);
        testObjectTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnTestObjectId = new TableViewerColumn(this.testObjectTableViewer, 16384);
        TableColumn tableColumnId = tableViewerColumnTestObjectId.getColumn();
        tableColumnId.setText(StringConstants.COL_TEST_OBJECT_ID);
        tableViewerColumnTestObjectId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TestObjectEntity testObject = (TestObjectEntity)element;
                return testObject.getId();
            }
        });
        TableColumnLayout testObjectTableLayout = new TableColumnLayout();
        testObjectTableLayout.setColumnData((Widget)tableColumnId, (ColumnLayoutData)new ColumnWeightData(100, 30));
        testObjectTableComposite.setLayout((Layout)testObjectTableLayout);
        this.testObjectTableViewer.setInput(this.selectedTestObjects);
        this.testObjectTableViewer.refresh();
    }

    private void createProfileSelectionSection(Composite parent) {
        Label lblProfile = new Label(parent, 0);
        lblProfile.setText(StringConstants.LBL_PROFILE);
        ToolBar toolBar = new ToolBar(parent, 8519744);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnAddProfile = new ToolItem(toolBar, 0x800000);
        this.btnAddProfile.setText(StringConstants.TOOL_ITEM_ADD);
        this.btnAddProfile.setImage(ImageConstants.IMG_16_ADD);
        this.btnDeleteProfile = new ToolItem(toolBar, 0x800000);
        this.btnDeleteProfile.setText(StringConstants.TOOL_ITEM_DELETE);
        this.btnDeleteProfile.setImage(ImageConstants.IMG_16_DELETE);
        this.btnDeleteProfile.setEnabled(false);
        Composite profileTableComposite = new Composite(parent, 0);
        GridData gdProfileTableComposite = new GridData(4, 4, true, true);
        gdProfileTableComposite.heightHint = 200;
        profileTableComposite.setLayoutData((Object)gdProfileTableComposite);
        profileTableComposite.setLayout((Layout)new FillLayout());
        this.profileTableViewer = new TableViewer(profileTableComposite, 2050);
        this.profileTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table profileTable = this.profileTableViewer.getTable();
        profileTable.setHeaderVisible(true);
        profileTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnProfileId = new TableViewerColumn(this.profileTableViewer, 16384);
        TableColumn tableColumnId = tableViewerColumnProfileId.getColumn();
        tableColumnId.setText(StringConstants.COL_PROFILE_ID);
        tableViewerColumnProfileId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ExecutionProfileEntity profile = (ExecutionProfileEntity)element;
                return profile.getId();
            }
        });
        TableColumnLayout profileTableLayout = new TableColumnLayout();
        profileTableLayout.setColumnData((Widget)tableColumnId, (ColumnLayoutData)new ColumnWeightData(100, 30));
        profileTableComposite.setLayout((Layout)profileTableLayout);
        this.profileTableViewer.setInput(this.selectedProfiles);
        this.profileTableViewer.refresh();
    }

    private void createKeywordSelectionSection(Composite parent) {
        Label lblKeyword = new Label(parent, 0);
        lblKeyword.setText(StringConstants.LBL_KEYWORD);
        ToolBar toolBar = new ToolBar(parent, 8519744);
        toolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnAddKeyword = new ToolItem(toolBar, 0x800000);
        this.btnAddKeyword.setText(StringConstants.TOOL_ITEM_ADD);
        this.btnAddKeyword.setImage(ImageConstants.IMG_16_ADD);
        this.btnDeleteKeyword = new ToolItem(toolBar, 0x800000);
        this.btnDeleteKeyword.setText(StringConstants.TOOL_ITEM_DELETE);
        this.btnDeleteKeyword.setImage(ImageConstants.IMG_16_DELETE);
        this.btnDeleteKeyword.setEnabled(false);
        Composite keywordTableComposite = new Composite(parent, 0);
        GridData gdKeywordTableComposite = new GridData(4, 4, true, true);
        gdKeywordTableComposite.heightHint = 200;
        keywordTableComposite.setLayoutData((Object)gdKeywordTableComposite);
        keywordTableComposite.setLayout((Layout)new FillLayout());
        this.keywordTableViewer = new TableViewer(keywordTableComposite, 2050);
        this.keywordTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Table keywordTable = this.keywordTableViewer.getTable();
        keywordTable.setHeaderVisible(true);
        keywordTable.setLinesVisible(true);
        TableViewerColumn tableViewerColumnKeywordId = new TableViewerColumn(this.keywordTableViewer, 16384);
        TableColumn tableColumnId = tableViewerColumnKeywordId.getColumn();
        tableColumnId.setText(StringConstants.COL_KEYWORD_ID);
        tableViewerColumnKeywordId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                File keyword = (File)element;
                String keywordFilePath = keyword.getAbsolutePath();
                String keywordRelativeId = keywordFilePath.substring(keywordFilePath.indexOf("Keywords"));
                return FilenameUtils.removeExtension((String)keywordRelativeId);
            }
        });
        TableColumnLayout keywordTableLayout = new TableColumnLayout();
        keywordTableLayout.setColumnData((Widget)tableColumnId, (ColumnLayoutData)new ColumnWeightData(100, 30));
        keywordTableComposite.setLayout((Layout)keywordTableLayout);
        this.keywordTableViewer.setInput(this.selectedKeywords);
        this.keywordTableViewer.refresh();
    }

    private void createExportLocationSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout glComposite = new GridLayout(1, false);
        glComposite.marginWidth = 0;
        composite.setLayout((Layout)glComposite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblExportLocation = new Label(composite, 0);
        lblExportLocation.setText(StringConstants.LBL_EXPORT_LOCATION);
        Composite fileChooserComposite = new Composite(composite, 0);
        GridLayout glFileChooserComposite = new GridLayout(2, false);
        glFileChooserComposite.marginWidth = 0;
        fileChooserComposite.setLayout((Layout)glFileChooserComposite);
        fileChooserComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtExportLocation = new Text(fileChooserComposite, 2048);
        this.txtExportLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnChooseExportFolder = new Button(fileChooserComposite, 0);
        this.btnChooseExportFolder.setText(StringConstants.BTN_BROWSE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void registerControlListeners() {
        this.btnAddTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = e.widget.getDisplay().getActiveShell();
                try {
                    TestCaseEntity[] testCaseEntities = PlatformUtil.getUIService(DialogActionService.class).showTestCaseSelectionDialog(activeShell, "Select test cases");
                    ExportTestArtifactDialog.this.selectedTestCases.addAll(Arrays.asList(testCaseEntities));
                    ExportTestArtifactDialog.this.testCaseTableViewer.refresh();
                }
                catch (PlatformException ex) {
                    MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnDeleteTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                Object[] objectArray = selections = ExportTestArtifactDialog.this.testCaseTableViewer.getStructuredSelection().toArray();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object testCase = objectArray[n2];
                    ExportTestArtifactDialog.this.selectedTestCases.remove((TestCaseEntity)testCase);
                    ++n2;
                }
                ExportTestArtifactDialog.this.testCaseTableViewer.refresh();
                if (ExportTestArtifactDialog.this.selectedTestCases.isEmpty()) {
                    ExportTestArtifactDialog.this.btnDeleteTestCase.setEnabled(false);
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.testCaseTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selections = ExportTestArtifactDialog.this.testCaseTableViewer.getStructuredSelection().toArray();
                if (selections != null && selections.length > 0) {
                    ExportTestArtifactDialog.this.btnDeleteTestCase.setEnabled(true);
                } else {
                    ExportTestArtifactDialog.this.btnDeleteTestCase.setEnabled(false);
                }
            }
        });
        this.btnAddTestObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = e.widget.getDisplay().getActiveShell();
                try {
                    TestObjectEntity[] testObjectEntities = PlatformUtil.getUIService(DialogActionService.class).showTestObjectSelectionDialog(activeShell, "Select test objects");
                    ExportTestArtifactDialog.this.selectedTestObjects.addAll(Arrays.asList(testObjectEntities));
                    ExportTestArtifactDialog.this.testObjectTableViewer.refresh();
                }
                catch (PlatformException ex) {
                    MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnDeleteTestObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                Object[] objectArray = selections = ExportTestArtifactDialog.this.testObjectTableViewer.getStructuredSelection().toArray();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object testObject = objectArray[n2];
                    ExportTestArtifactDialog.this.selectedTestObjects.remove((TestObjectEntity)testObject);
                    ++n2;
                }
                ExportTestArtifactDialog.this.testObjectTableViewer.refresh();
                if (ExportTestArtifactDialog.this.selectedTestObjects.isEmpty()) {
                    ExportTestArtifactDialog.this.btnDeleteTestObject.setEnabled(false);
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.testObjectTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selections = ExportTestArtifactDialog.this.testObjectTableViewer.getStructuredSelection().toArray();
                if (selections != null && selections.length > 0) {
                    ExportTestArtifactDialog.this.btnDeleteTestObject.setEnabled(true);
                } else {
                    ExportTestArtifactDialog.this.btnDeleteTestObject.setEnabled(false);
                }
            }
        });
        this.btnAddProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = e.widget.getDisplay().getActiveShell();
                try {
                    ExecutionProfileEntity[] profileEntities = PlatformUtil.getUIService(DialogActionService.class).showExecutionProfileSelectionDialog(activeShell, "Select profiles");
                    ExportTestArtifactDialog.this.selectedProfiles.addAll(Arrays.asList(profileEntities));
                    ExportTestArtifactDialog.this.profileTableViewer.refresh();
                }
                catch (PlatformException ex) {
                    MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnDeleteProfile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                Object[] objectArray = selections = ExportTestArtifactDialog.this.profileTableViewer.getStructuredSelection().toArray();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object profile = objectArray[n2];
                    ExportTestArtifactDialog.this.selectedProfiles.remove((ExecutionProfileEntity)profile);
                    ++n2;
                }
                ExportTestArtifactDialog.this.profileTableViewer.refresh();
                if (ExportTestArtifactDialog.this.selectedProfiles.isEmpty()) {
                    ExportTestArtifactDialog.this.btnDeleteProfile.setEnabled(false);
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.profileTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selections = ExportTestArtifactDialog.this.profileTableViewer.getStructuredSelection().toArray();
                if (selections != null && selections.length > 0) {
                    ExportTestArtifactDialog.this.btnDeleteProfile.setEnabled(true);
                } else {
                    ExportTestArtifactDialog.this.btnDeleteProfile.setEnabled(false);
                }
            }
        });
        this.btnAddKeyword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = e.widget.getDisplay().getActiveShell();
                try {
                    List<File> keywords = ExportTestArtifactDialog.this.showKeywordSelectionDialog(activeShell);
                    ExportTestArtifactDialog.this.selectedKeywords.addAll(keywords);
                    ExportTestArtifactDialog.this.keywordTableViewer.refresh();
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)activeShell, (String)StringConstants.ERROR, (String)ex.getMessage());
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.btnDeleteKeyword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selections;
                Object[] objectArray = selections = ExportTestArtifactDialog.this.keywordTableViewer.getStructuredSelection().toArray();
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object keyword = objectArray[n2];
                    ExportTestArtifactDialog.this.selectedKeywords.remove((File)keyword);
                    ++n2;
                }
                ExportTestArtifactDialog.this.keywordTableViewer.refresh();
                if (ExportTestArtifactDialog.this.selectedKeywords.isEmpty()) {
                    ExportTestArtifactDialog.this.btnDeleteKeyword.setEnabled(false);
                }
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.keywordTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selections = ExportTestArtifactDialog.this.keywordTableViewer.getStructuredSelection().toArray();
                if (selections != null && selections.length > 0) {
                    ExportTestArtifactDialog.this.btnDeleteKeyword.setEnabled(true);
                } else {
                    ExportTestArtifactDialog.this.btnDeleteKeyword.setEnabled(false);
                }
            }
        });
        this.btnChooseExportFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(e.widget.getDisplay().getActiveShell());
                directoryDialog.setFilterPath(ExportTestArtifactDialog.this.txtExportLocation.getText());
                String directoryLocation = directoryDialog.open();
                ExportTestArtifactDialog.this.txtExportLocation.setText(directoryLocation);
                ExportTestArtifactDialog.this.validateInput();
            }
        });
        this.txtExportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExportTestArtifactDialog.this.validateInput();
            }
        });
    }

    private List<File> showKeywordSelectionDialog(Shell parentShell) throws Exception {
        FolderTreeEntity keywordFolderRoot;
        EntityLabelProvider labelProvider = new EntityLabelProvider();
        EntityProvider contentProvider = new EntityProvider();
        KeywordSelectionDialog selectionDialog = new KeywordSelectionDialog(parentShell, (IEntityLabelProvider)labelProvider, (ITreeContentProvider)contentProvider, (AbstractEntityViewerFilter)new EntityViewerFilter(contentProvider));
        selectionDialog.setTitle("Select keywords");
        selectionDialog.setAllowMultiple(false);
        try {
            keywordFolderRoot = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
        }
        catch (Exception e) {
            throw new ResourceException("Could not initialize profile folder", e);
        }
        selectionDialog.setInput(Arrays.asList(keywordFolderRoot));
        if (selectionDialog.open() != 0 || selectionDialog.getResult() == null) {
            return Collections.emptyList();
        }
        KeywordTreeEntity[] selectedTreeEntities = selectionDialog.getSelectedKeywords();
        ArrayList<File> selectedKeywords = new ArrayList<File>();
        KeywordTreeEntity[] keywordTreeEntityArray = selectedTreeEntities;
        int n = selectedTreeEntities.length;
        int n2 = 0;
        while (n2 < n) {
            KeywordTreeEntity selectedTreeEntity = keywordTreeEntityArray[n2];
            ICompilationUnit compilationUnit = (ICompilationUnit)selectedTreeEntity.getObject();
            String location = compilationUnit.getResource().getLocation().toString();
            File keyword = new File(location);
            selectedKeywords.add(keyword);
            ++n2;
        }
        return selectedKeywords;
    }

    private void validateInput() {
        boolean isValid = (!this.selectedTestCases.isEmpty() || !this.selectedTestObjects.isEmpty() || !this.selectedProfiles.isEmpty() || !this.selectedKeywords.isEmpty()) && StringUtils.isNotBlank((CharSequence)this.txtExportLocation.getText());
        this.getButton(0).setEnabled(isValid);
    }

    protected void okPressed() {
        this.dialogResult = new ExportTestArtifactDialogResult();
        this.dialogResult.setSelectedTestCases(this.filterDuplicatedTestCases(this.selectedTestCases));
        this.dialogResult.setSelectedTestObjects(this.filterDuplicatedTestObjects(this.selectedTestObjects));
        this.dialogResult.setSelectedProfiles(this.filterDuplicatedProfiles(this.selectedProfiles));
        this.dialogResult.setSelectedKeywords(this.filterDuplicatedKeywords(this.selectedKeywords));
        this.dialogResult.setExportLocation(this.txtExportLocation.getText());
        super.okPressed();
    }

    private List<TestCaseEntity> filterDuplicatedTestCases(List<TestCaseEntity> testCases) {
        HashSet<String> testCaseIds = new HashSet<String>();
        ArrayList<TestCaseEntity> filteredResult = new ArrayList<TestCaseEntity>();
        for (TestCaseEntity testCase : testCases) {
            if (testCaseIds.contains(testCase.getId())) continue;
            filteredResult.add(testCase);
            testCaseIds.add(testCase.getId());
        }
        return filteredResult;
    }

    private List<TestObjectEntity> filterDuplicatedTestObjects(List<TestObjectEntity> testObjects) {
        HashSet<String> testObjectIds = new HashSet<String>();
        ArrayList<TestObjectEntity> filteredResult = new ArrayList<TestObjectEntity>();
        for (TestObjectEntity testObject : testObjects) {
            if (testObjectIds.contains(testObject.getId())) continue;
            filteredResult.add(testObject);
            testObjectIds.add(testObject.getId());
        }
        return filteredResult;
    }

    private List<ExecutionProfileEntity> filterDuplicatedProfiles(List<ExecutionProfileEntity> profiles) {
        HashSet<String> profileIds = new HashSet<String>();
        ArrayList<ExecutionProfileEntity> filteredResult = new ArrayList<ExecutionProfileEntity>();
        for (ExecutionProfileEntity profile : profiles) {
            if (profileIds.contains(profile.getId())) continue;
            filteredResult.add(profile);
            profileIds.add(profile.getId());
        }
        return filteredResult;
    }

    private List<File> filterDuplicatedKeywords(List<File> keywords) {
        HashSet<String> keywordIds = new HashSet<String>();
        ArrayList<File> filteredResult = new ArrayList<File>();
        for (File keyword : keywords) {
            if (keywordIds.contains(keyword.getAbsolutePath())) continue;
            filteredResult.add(keyword);
            keywordIds.add(keyword.getAbsolutePath());
        }
        return filteredResult;
    }

    public ExportTestArtifactDialogResult getResult() {
        return this.dialogResult;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(StringConstants.DIALOG_TITLE_EXPORT_TEST_ARTIFACTS);
    }

    public class ExportTestArtifactDialogResult {
        private List<TestCaseEntity> selectedTestCases;
        private List<TestObjectEntity> selectedTestObjects;
        private List<ExecutionProfileEntity> selectedProfiles;
        private List<File> selectedKeywords;
        private String exportLocation;

        public List<TestCaseEntity> getSelectedTestCases() {
            return this.selectedTestCases;
        }

        public void setSelectedTestCases(List<TestCaseEntity> selectedTestCases) {
            this.selectedTestCases = selectedTestCases;
        }

        public List<TestObjectEntity> getSelectedTestObjects() {
            return this.selectedTestObjects;
        }

        public void setSelectedTestObjects(List<TestObjectEntity> selectedTestObjects) {
            this.selectedTestObjects = selectedTestObjects;
        }

        public List<ExecutionProfileEntity> getSelectedProfiles() {
            return this.selectedProfiles;
        }

        public void setSelectedProfiles(List<ExecutionProfileEntity> selectedProfiles) {
            this.selectedProfiles = selectedProfiles;
        }

        public List<File> getSelectedKeywords() {
            return this.selectedKeywords;
        }

        public void setSelectedKeywords(List<File> selectedKeywords) {
            this.selectedKeywords = selectedKeywords;
        }

        public String getExportLocation() {
            return this.exportLocation;
        }

        public void setExportLocation(String exportLocation) {
            this.exportLocation = exportLocation;
        }
    }
}

