/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.sf.feeling.decompiler.SetupRunnable;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.extension.DecompilerAdapterManager;
import org.sf.feeling.decompiler.source.attach.IAttachSourceHandler;
import org.sf.feeling.decompiler.util.DefaultDecompilerDescriptorComparator;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.SortMemberUtil;

public class JavaDecompilerPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    private static final String ECD_DECOMPILER_CLASS_NAME_PREFIX = "org.sf.feeling.decompiler";
    private static final List<String> ALLOWED_PLUGINS = Arrays.asList("cfr", "fernflower", "jd", "procyon", "vineflower");
    private static JavaDecompilerPlugin plugin;
    private IPreferenceStore preferenceStore;
    private TreeMap<String, IDecompilerDescriptor> decompilerDescriptorMap = new TreeMap();
    private boolean isDebugMode = false;
    private int sourceMode = 0;
    private final Set<String> libraries = new ConcurrentSkipListSet<String>();

    public Map<String, IDecompilerDescriptor> getDecompilerDescriptorMap() {
        return this.decompilerDescriptorMap;
    }

    public String[] getDecompilerDescriptorTypes() {
        return this.decompilerDescriptorMap.keySet().toArray(new String[0]);
    }

    public IDecompilerDescriptor getDecompilerDescriptor(String decompilerType) {
        return this.decompilerDescriptorMap.get(decompilerType);
    }

    public static JavaDecompilerPlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t, String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, ECD_DECOMPILER_CLASS_NAME_PREFIX, 0, message, t));
    }

    public static void logInfo(String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(1, ECD_DECOMPILER_CLASS_NAME_PREFIX, 0, message, null));
    }

    public static void log(int severity, Throwable t, String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(severity, ECD_DECOMPILER_CLASS_NAME_PREFIX, 0, message, t));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL base = JavaDecompilerPlugin.getDefault().getBundle().getEntry("/");
        URL url = null;
        try {
            url = new URL(base, path);
        }
        catch (MalformedURLException e) {
            Logger.debug(e);
        }
        ImageDescriptor actionIcon = null;
        if (url != null) {
            actionIcon = ImageDescriptor.createFromURL((URL)url);
        }
        return actionIcon;
    }

    public JavaDecompilerPlugin() {
        plugin = this;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.sf.feeling.decompiler.tempd", String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + ".org.sf.feeling.decompiler" + System.currentTimeMillis());
        store.setDefault("org.sf.feeling.decompiler.reusebuff", true);
        store.setDefault("org.sf.feeling.decompiler.alwaysuse", false);
        store.setDefault("org.sf.feeling.decompiler.use_eclipse_formatter", true);
        store.setDefault("org.sf.feeling.decompiler.use_eclipse_sorter", false);
        store.setDefault("jd.ide.eclipse.prefs.DisplayMetadata", false);
        store.setDefault("org.sf.feeling.decompiler.default_editor", true);
        store.setDefault("org.sf.feeling.decompiler.attach_source", false);
        store.setDefault("org.sf.feeling.decompiler.export.encoding", StandardCharsets.UTF_8.name());
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"BYTECODEMNEMONIC_bytecodeMnemonic", (RGB)new RGB(0, 0, 0));
        store.setDefault("BYTECODEMNEMONIC_bytecodeMnemonic_bold", true);
        store.setDefault("BYTECODEMNEMONIC_bytecodeMnemonic_italic", false);
        store.setDefault("BYTECODEMNEMONIC_bytecodeMnemonic_strikethrough", false);
        store.setDefault("BYTECODEMNEMONIC_bytecodeMnemonic_underline", false);
        store.setDefault("CLASS_FILE_ATTR_show_constantPool", false);
        store.setDefault("CLASS_FILE_ATTR_show_lineNumberTable", false);
        store.setDefault("CLASS_FILE_ATTR_show_localVariableTable", false);
        store.setDefault("CLASS_FILE_ATTR_show_exceptionTable", false);
        store.setDefault("CLASS_FILE_ATTR_show_maxs", false);
        store.setDefault("BRANCH_TARGET_ADDRESS_RENDERING", "BRANCH_TARGET_ADDRESS_RENDERING_RELATIVE");
        store.setDefault("CLASS_FILE_ATTR_render_tryCatchBlocks", true);
        store.setDefault("CLASS_FILE_ATTR_render_sourceLineNumbers", true);
        store.setDefault("CLASS_FILE_ATTR_show_maxs", false);
    }

    private void initializeDecompilerDescriptorMap(IPreferenceStore store) {
        List<IDecompilerDescriptor> decompilerAdapters = DecompilerAdapterManager.getAdapterList((Object)this, IDecompilerDescriptor.class);
        if (decompilerAdapters != null) {
            for (IDecompilerDescriptor descriptor : decompilerAdapters) {
                String name;
                int idx;
                String className = descriptor.getClass().getName();
                if (className.startsWith(ECD_DECOMPILER_CLASS_NAME_PREFIX) && (idx = (name = className.substring(ECD_DECOMPILER_CLASS_NAME_PREFIX.length() + 1)).indexOf(46)) > 0) {
                    boolean allowed;
                    boolean bl = allowed = ALLOWED_PLUGINS.indexOf(name = name.substring(0, idx)) >= 0;
                    if (!allowed) {
                        Logger.error("Disabling unknown decompiler plugin: " + className);
                        continue;
                    }
                }
                if (!descriptor.isEnabled()) continue;
                this.decompilerDescriptorMap.put(descriptor.getDecompilerType(), descriptor);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.sf.feeling.decompiler.alwaysuse")) {
            JavaDecompilerBufferManager.closeDecompilerBuffers(false);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeDecompilerDescriptorMap(this.getPreferenceStore());
        this.initializeDefaultDecompilerType();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        SortMemberUtil.deleteDecompilerProject();
        Display.getDefault().asyncExec((Runnable)new SetupRunnable());
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            String defaultDecompiler;
            this.preferenceStore = super.getPreferenceStore();
            String decompilerType = this.preferenceStore.getString("org.sf.feeling.decompiler.type");
            IDecompilerDescriptor descriptor = this.getDecompilerDescriptor(decompilerType);
            if (descriptor == null && (defaultDecompiler = this.getDefaultDecompilerType()) != null) {
                this.preferenceStore.setDefault("org.sf.feeling.decompiler.type", defaultDecompiler);
            }
        }
        return this.preferenceStore;
    }

    public void initializeDefaultDecompilerType() {
        String defaultDecompiler;
        String decompilerType = this.preferenceStore.getString("org.sf.feeling.decompiler.type");
        IDecompilerDescriptor descriptor = this.getDecompilerDescriptor(decompilerType);
        if (descriptor != null) {
            return;
        }
        Collection<IDecompilerDescriptor> descriptorColl = JavaDecompilerPlugin.getDefault().getDecompilerDescriptorMap().values();
        if (!descriptorColl.isEmpty() && (defaultDecompiler = this.getDefaultDecompilerType()) != null) {
            this.preferenceStore.setDefault("org.sf.feeling.decompiler.type", defaultDecompiler);
        }
    }

    public void stop(BundleContext context) throws Exception {
        FileUtil.deltree(new File(this.getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")));
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
    }

    public Boolean isDisplayLineNumber() {
        return this.getPreferenceStore().getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
    }

    public Boolean isDebug() {
        return this.getPreferenceStore().getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
    }

    public void displayLineNumber(Boolean display) {
        this.getPreferenceStore().setValue("jd.ide.eclipse.prefs.DisplayLineNumbers", display.booleanValue());
    }

    public void setExportEncoding(String encoding) {
        this.getPreferenceStore().setValue("org.sf.feeling.decompiler.export.encoding", encoding);
    }

    public String getExportEncoding() {
        return this.getPreferenceStore().getString("org.sf.feeling.decompiler.export.encoding");
    }

    public boolean enableAttachSourceSetting() {
        Object attachSourceAdapter = DecompilerAdapterManager.getAdapter((Object)this, IAttachSourceHandler.class);
        return attachSourceAdapter instanceof IAttachSourceHandler;
    }

    public void attachSource(IPackageFragmentRoot library, boolean force) {
        Object attachSourceAdapter = DecompilerAdapterManager.getAdapter((Object)this, IAttachSourceHandler.class);
        if (attachSourceAdapter instanceof IAttachSourceHandler && (!this.libraries.contains(library.getPath().toOSString()) || force)) {
            this.libraries.add(library.getPath().toOSString());
            ((IAttachSourceHandler)attachSourceAdapter).execute(library, force);
        }
    }

    public void syncLibrarySource(IPackageFragmentRoot library) {
        try {
            Object attachSourceAdapter;
            IPreferenceStore prefs;
            if (library.getPath() != null && library.getSourceAttachmentPath() != null && !this.libraries.contains(library.getPath().toOSString()) && (prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore()).getBoolean("org.sf.feeling.decompiler.default_editor") && (attachSourceAdapter = DecompilerAdapterManager.getAdapter((Object)JavaDecompilerPlugin.getDefault(), IAttachSourceHandler.class)) instanceof IAttachSourceHandler) {
                this.libraries.add(library.getPath().toOSString());
                if (!((IAttachSourceHandler)attachSourceAdapter).syncAttachSource(library)) {
                    this.libraries.remove(library.getPath().toOSString());
                }
            }
        }
        catch (JavaModelException e) {
            Logger.debug(e);
        }
    }

    public boolean isAutoAttachSource() {
        if (!this.enableAttachSourceSetting()) {
            return false;
        }
        return this.getPreferenceStore().getBoolean("org.sf.feeling.decompiler.attach_source");
    }

    public String getDefaultDecompilerType() {
        Collection<IDecompilerDescriptor> descriptorColl = JavaDecompilerPlugin.getDefault().getDecompilerDescriptorMap().values();
        if (!descriptorColl.isEmpty()) {
            IDecompilerDescriptor defaultDecompilerDescr = descriptorColl.stream().sorted(new DefaultDecompilerDescriptorComparator()).findFirst().get();
            return defaultDecompilerDescr.getDecompilerType();
        }
        return null;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    public int getSourceMode() {
        return this.sourceMode;
    }

    public void setSourceMode(int sourceMode) {
        this.sourceMode = sourceMode;
    }

    public String getDefaultExportEncoding() {
        return this.getPreferenceStore().getDefaultString("org.sf.feeling.decompiler.export.encoding");
    }
}

