/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.util.Arrays;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.util.EclipseCompatibilityHelper;
import org.sf.feeling.decompiler.util.SourceMapperUtil;

public class ClassFileSourceMap {
    private static IType getOuterMostEnclosingType(ClassFile cf) {
        IType type = cf.getType();
        IType enclosingType = type.getDeclaringType();
        while (enclosingType != null) {
            type = enclosingType;
            enclosingType = type.getDeclaringType();
        }
        return type;
    }

    private static void mapSource(JavaDecompilerBufferManager bufferManager, ClassFile cf, SourceMapper mapper, IBinaryType info, IClassFile bufferOwner, char[] markedSrc) {
        char[] contents = mapper.findSource(cf.getType(), info);
        if (Arrays.equals(markedSrc, contents)) {
            return;
        }
        contents = markedSrc;
        if (contents != null) {
            IBuffer buffer = BufferManager.createBuffer((IOpenable)bufferOwner);
            if (buffer == null) {
                return;
            }
            JavaDecompilerBufferManager bufManager = bufferManager;
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            SourceMapperUtil.mapSource(mapper, ClassFileSourceMap.getOuterMostEnclosingType(cf), contents, info);
            return;
        }
        IBuffer buffer = BufferManager.createNullBuffer((IOpenable)bufferOwner);
        if (buffer == null) {
            return;
        }
        JavaDecompilerBufferManager bufManager = bufferManager;
        bufManager.addBuffer(buffer);
    }

    public static void updateSource(JavaDecompilerBufferManager bufferManager, ClassFile cf, char[] markedSrc) throws JavaModelException {
        IBinaryType typeInfo;
        IType type = cf.getType();
        if (!type.isBinary()) {
            return;
        }
        Object info = EclipseCompatibilityHelper.javaElementGetElementInfo((JavaElement)cf);
        IType enclosingType = type.getDeclaringType();
        while (enclosingType != null) {
            type = enclosingType;
            enclosingType = type.getDeclaringType();
        }
        IType outerMostEnclosingType = type;
        SourceMapper mapper = cf.getSourceMapper();
        IBinaryType iBinaryType = typeInfo = info instanceof IBinaryType ? (IBinaryType)info : null;
        if (mapper != null) {
            ClassFileSourceMap.mapSource(bufferManager, cf, mapper, typeInfo, (IClassFile)outerMostEnclosingType.getClassFile(), markedSrc);
        }
    }
}

