/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.asm.render.intf.IClassFileDocument;
import com.drgarbage.asm.render.intf.IInstructionLine;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.sf.feeling.decompiler.editor.DisassemblerDocumentProvider;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;

public class DisassemblerDocument
extends Document {
    private DisassemblerDocumentProvider documentProvider;
    private JavaDecompilerClassFileEditor editor;

    public JavaDecompilerClassFileEditor getEditor() {
        return this.editor;
    }

    public DisassemblerDocument(DisassemblerDocumentProvider documentProvider, JavaDecompilerClassFileEditor editor) {
        this.documentProvider = documentProvider;
        this.editor = editor;
    }

    public DisassemblerDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public IRegion getLineInformation(int line) throws BadLocationException {
        if (line < 0) {
            return new Region(0, 0);
        }
        if (this.invokedFromJavaStackTraceHyperlink(3)) {
            IInstructionLine il;
            IClassFileDocument doc = this.documentProvider.getClassFileDocument();
            if (doc != null && (il = doc.findInstructionLine(line)) != null) {
                IRegion result = this.getTracker().getLineInformation(il.getLine());
                return result;
            }
        } else {
            return this.getTracker().getLineInformation(line);
        }
        return new Region(0, 0);
    }

    private boolean invokedFromJavaStackTraceHyperlink(int position) {
        Thread thread = Thread.currentThread();
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements != null && elements.length > position) {
            return JavaStackTraceHyperlink.class.getName().equals(elements[position].getClassName());
        }
        return false;
    }
}

