/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.util.DecompilerOutputUtil;

public final class CommentUtil {
    public static final String LINE_NUMBER_COMMENT = "/\\*\\s*\\d+\\s*\\*/";

    private CommentUtil() {
    }

    public static String clearComments(String input) {
        ASTParser parser = ASTParser.newParser((int)DecompilerOutputUtil.getMaxJSLLevel());
        CompilerOptions option = new CompilerOptions();
        Map options = option.getMap();
        options.put("org.eclipse.jdt.core.compiler.compliance", DecompilerOutputUtil.getMaxDecompileLevel());
        options.put("org.eclipse.jdt.core.compiler.source", DecompilerOutputUtil.getMaxDecompileLevel());
        parser.setCompilerOptions(options);
        parser.setSource(input.toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        AST ast = unit.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        Document document = new Document(input);
        TextEdit edits = rewriter.rewriteAST((IDocument)document, null);
        ArrayList<DeleteEdit> textEdits = new ArrayList<DeleteEdit>();
        List commentList = unit.getCommentList();
        for (Comment comment : commentList) {
            int commentLength;
            int commentEnd;
            BlockComment blockComment;
            int commentStart;
            String commentText;
            if (!comment.isBlockComment() || (commentText = input.substring(commentStart = (blockComment = (BlockComment)comment).getStartPosition(), commentEnd = commentStart + (commentLength = blockComment.getLength()))).trim().matches(LINE_NUMBER_COMMENT)) continue;
            textEdits.add(new DeleteEdit(commentStart, commentLength));
        }
        edits.addChildren(textEdits.toArray(new TextEdit[textEdits.size()]));
        try {
            edits.apply((IDocument)document);
        }
        catch (BadLocationException | MalformedTreeException e) {
            JavaDecompilerPlugin.logError(e, e.getMessage());
        }
        return document.get();
    }
}

