/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassExtractor {
    public static void extract(String archivePath, String packege, String className, boolean inner, String to) throws IOException {
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipFile archive = new ZipFile(archivePath);){
            List<ZipEntry> entries = JarClassExtractor.findRelevant(archive, packege, className, inner);
            byte[] buffer = new byte[16384];
            for (ZipEntry entry : entries) {
                String outFile = entry.getName();
                int lastSep = outFile.lastIndexOf(47);
                if (lastSep != -1) {
                    outFile = outFile.substring(lastSep);
                }
                Throwable throwable2 = null;
                Object var16_19 = null;
                try (InputStream in = archive.getInputStream(entry);){
                    if (in == null) {
                        throw new IOException("Zip file entry <" + entry.getName() + "> not found");
                    }
                    Path outPath = Paths.get(String.valueOf(to) + File.separator + outFile, new String[0]);
                    Throwable throwable3 = null;
                    Object var20_25 = null;
                    try (OutputStream out = Files.newOutputStream(outPath, new OpenOption[0]);){
                        int amountRead;
                        while ((amountRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, amountRead);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private static List<ZipEntry> findRelevant(ZipFile archive, String packege, String className, boolean inner) {
        String entryName = packege.length() == 0 ? className : String.valueOf(packege) + "/" + className;
        String innerPrefix = String.valueOf(entryName.substring(0, entryName.length() - 6)) + "$";
        Enumeration<? extends ZipEntry> entries = archive.entries();
        ArrayList<ZipEntry> relevant = new ArrayList<ZipEntry>();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.equals(entryName) && (!name.startsWith(innerPrefix) || !inner)) continue;
            relevant.add(entry);
        }
        return relevant;
    }
}

