/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.AiAutoTagConfig;
import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.NoneConfig;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.OpenAiCompatibleConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistUnavailableException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.ai.preferences.AwsBedrockPreferenceStore;
import com.kms.katalon.ai.preferences.AzureOpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.GeminiPreferenceStore;
import com.kms.katalon.ai.preferences.GenAIPreferenceStore;
import com.kms.katalon.ai.preferences.LegacyOpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.ManagedAzureOpenAiPreferenceStore;
import com.kms.katalon.ai.preferences.ManagedGeminiPreferenceStore;
import com.kms.katalon.ai.preferences.ManagedOpenAiCompatiblePreferenceStore;
import com.kms.katalon.ai.preferences.ManagedOpenAiPreferenceStore;
import com.kms.katalon.ai.preferences.NonePreferenceStore;
import com.kms.katalon.ai.preferences.OpenAIPreferenceStore;
import com.kms.katalon.ai.preferences.OpenAiCompatiblePreferenceStore;
import com.kms.katalon.ai.preferences.StudioAssistPreferenceStore;
import com.kms.katalon.ai.preferences.UserManagedAiAutoTagSetting;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.session.core.model.AiAutoTagPolicyType;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class StudioAssistPreferences
implements IStudioAssistPreferences {
    public StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        AiConfigPolicyType aiConfigPolicyType = applicationContext.getAiConfigPolicy().getAiConfigPolicyType();
        StudioAssistPreferenceStore store = null;
        block0 : switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                store = new ManagedAzureOpenAiPreferenceStore(applicationContext);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                store = new ManagedOpenAiPreferenceStore(applicationContext);
                break;
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                store = new ManagedGeminiPreferenceStore(applicationContext);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                store = new ManagedOpenAiCompatiblePreferenceStore(applicationContext);
                break;
            }
            default: {
                StudioAssistConfigType configType = StudioAssistPreferenceStore.getSavedConfigType();
                switch (configType) {
                    case OPENAI: {
                        store = new OpenAIPreferenceStore();
                        break block0;
                    }
                    case AZURE_OPENAI: {
                        store = new AzureOpenAIPreferenceStore();
                        break block0;
                    }
                    case GEN_AI: {
                        store = new GenAIPreferenceStore();
                        break block0;
                    }
                    case GEMINI: {
                        store = new GeminiPreferenceStore();
                        break block0;
                    }
                    case OPENAI_COMPATIBLE: {
                        store = new OpenAiCompatiblePreferenceStore();
                        break block0;
                    }
                    case AWS_BEDROCK: {
                        store = new AwsBedrockPreferenceStore();
                        break block0;
                    }
                    case NONE: {
                        store = new NonePreferenceStore();
                        break block0;
                    }
                }
                store = new LegacyOpenAIPreferenceStore();
            }
        }
        return store.getConfig();
    }

    public void saveConfig(StudioAssistConfig config) throws StudioAssistSavingConfigException {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        AiConfigPolicyType aiConfigPolicyType = applicationContext.getAiConfigPolicy().getAiConfigPolicyType();
        StudioAssistPreferenceStore store = null;
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                store = new ManagedAzureOpenAiPreferenceStore(applicationContext);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                store = new ManagedOpenAiPreferenceStore(applicationContext);
                break;
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                store = new ManagedGeminiPreferenceStore(applicationContext);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                store = new ManagedOpenAiCompatiblePreferenceStore(applicationContext);
                break;
            }
            default: {
                store = config instanceof OpenAIConfig ? new OpenAIPreferenceStore() : (config instanceof AzureOpenAIConfig ? new AzureOpenAIPreferenceStore() : (config instanceof GeminiConfig ? new GeminiPreferenceStore() : (config instanceof OpenAiCompatibleConfig ? new OpenAiCompatiblePreferenceStore() : (config instanceof AwsBedrockConfig ? new AwsBedrockPreferenceStore() : (config instanceof NoneConfig ? new NonePreferenceStore() : new GenAIPreferenceStore())))));
            }
        }
        ((StudioAssistPreferenceStore)store).saveConfig(config);
    }

    public String getSavedCustomPrompt(PromptType promptType) throws StudioAssistUnavailableException {
        return this.getStore().getCustomPrompt(promptType);
    }

    public void setCustomPromptContentTemplate(PromptType promptType, String promptContent) throws StudioAssistSavingConfigException {
        this.getStore().saveCustomPrompt(promptType, promptContent);
    }

    private StudioAssistPreferenceStore getStore() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        AiConfigPolicyType aiConfigPolicyType = applicationContext.getAiConfigPolicy() == null ? null : applicationContext.getAiConfigPolicy().getAiConfigPolicyType();
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                return new ManagedAzureOpenAiPreferenceStore(applicationContext);
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                return new ManagedOpenAiPreferenceStore(applicationContext);
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                return new ManagedGeminiPreferenceStore(applicationContext);
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                return new ManagedOpenAiCompatiblePreferenceStore(applicationContext);
            }
        }
        StudioAssistConfigType configType = StudioAssistPreferenceStore.getSavedConfigType();
        switch (configType) {
            case OPENAI: {
                return new OpenAIPreferenceStore();
            }
            case AZURE_OPENAI: {
                return new AzureOpenAIPreferenceStore();
            }
            case GEN_AI: {
                return new GenAIPreferenceStore();
            }
            case OPENAI_COMPATIBLE: {
                return new OpenAiCompatiblePreferenceStore();
            }
            case AWS_BEDROCK: {
                return new AwsBedrockPreferenceStore();
            }
            case NONE: {
                return new NonePreferenceStore();
            }
        }
        return new LegacyOpenAIPreferenceStore();
    }

    public void saveStudioAssistAiAutoTagSetting(AiAutoTagConfig aiAutoTagSetting) throws StudioAssistSavingConfigException {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        AiAutoTagPolicyType taggingPolicyType = applicationContext.getAdministrationManagedKsSetting().getAiAutoTagging().getType();
        if (taggingPolicyType != AiAutoTagPolicyType.USER_MANAGED_AI_AUTO_TAG) {
            return;
        }
        UserManagedAiAutoTagSetting userSetting = new UserManagedAiAutoTagSetting();
        userSetting.saveConfig(aiAutoTagSetting);
    }
}

