/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.core.model;

import java.util.Optional;

public class SessionExpireSchedule {
    private static final long DEFAULT_LOG_OUT_AFTER_MILLISECONDS = 300000L;
    private final Reason reason;
    private final String message;
    private final Long scheduledLogoutTimeEpochMs;

    public SessionExpireSchedule(Reason reason, String message) {
        this(reason, message, Optional.empty());
    }

    public SessionExpireSchedule(Reason reason, String message, Optional<Long> scheduledLogoutTimeEpochMs) {
        this.reason = reason;
        this.message = message;
        this.scheduledLogoutTimeEpochMs = scheduledLogoutTimeEpochMs.orElse(System.currentTimeMillis() + 300000L);
    }

    public Reason getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getScheduledLogoutTimeEpochMs() {
        return this.scheduledLogoutTimeEpochMs;
    }

    public static enum Reason {
        TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW,
        TOKEN_WILL_EXPIRE_AND_FAILED_TO_RENEW,
        LICENSE_EXPIRED,
        LICENSE_ERROR,
        USER_IDLE;

    }
}

