/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.fernflower.decompiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompiler;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.CommentUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class FernFlowerDecompiler
extends BaseDecompiler {
    public static final String decompilerType = "FernFlower";
    public static final String decompilerVersion = "232.10203.10";
    private long time = 0L;
    private String source = "";
    private String log = "";
    ByteArrayOutputStream loggerStream;

    public void decompile(String root, String packege, String className) {
        File[] files;
        String classNameFilterTmp;
        File tmpDir;
        if (root == null || packege == null || className == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.exceptions.clear();
        this.log = "";
        this.source = "";
        this.loggerStream = new ByteArrayOutputStream();
        File workingDir = new File(String.valueOf(root) + "/" + packege);
        HashMap<String, String> mapOptions = new HashMap<String, String>();
        mapOptions.put("rsy", "1");
        mapOptions.put("dgs", "1");
        mapOptions.put("din", "1");
        mapOptions.put("den", "1");
        mapOptions.put("log", IFernflowerLogger.Severity.ERROR.name());
        mapOptions.put("asc", "1");
        if (ClassUtil.isDebug()) {
            mapOptions.put("__dump_original_lines__", "1");
            mapOptions.put("bsm", "1");
        }
        if (!(tmpDir = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()))).exists()) {
            tmpDir.mkdirs();
        }
        if ((classNameFilterTmp = className.toLowerCase()).endsWith(".class")) {
            classNameFilterTmp = classNameFilterTmp.substring(0, classNameFilterTmp.length() - 6);
        }
        final String classNameFilter = classNameFilterTmp;
        class EmbeddedConsoleDecompiler
        extends ConsoleDecompiler {
            protected EmbeddedConsoleDecompiler(File file, Map map) {
                super(file, map, (IFernflowerLogger)new PrintStreamLogger(new PrintStream(FernFlowerDecompiler.this.loggerStream)));
            }
        }
        EmbeddedConsoleDecompiler decompiler = new EmbeddedConsoleDecompiler(tmpDir, mapOptions);
        File[] fileArray = files = workingDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).startsWith(classNameFilter) && name.endsWith(".class");
            }
        });
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            decompiler.addSource(f);
            ++n2;
        }
        decompiler.decompileContext();
        File classFile = new File(tmpDir, className.replaceAll("(?i)\\.class", ".java"));
        this.source = UnicodeUtil.decode((String)FileUtil.getContent((File)classFile));
        classFile.delete();
        FileUtil.deltree((File)tmpDir);
        this.source = CommentUtil.clearComments((String)this.source);
        this.time = stopWatch.getTime();
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
            }
            catch (Exception e) {
                this.exceptions.add(e);
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
        this.time = stopWatch.getTime();
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public String getLog() {
        if (this.loggerStream != null) {
            return String.valueOf(this.log) + this.loggerStream.toString();
        }
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return decompilerType;
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return true;
    }

    public String getDecompilerName() {
        return decompilerType;
    }

    public String getDecompilerVersion() {
        return decompilerVersion;
    }
}

