/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.support;

import com.kms.katalon.composer.components.impl.components.ConnectionPropertyTable;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.db.ConnectionProperty;
import com.kms.katalon.core.db.DBConnectionProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ConnectionPropertyEditingSupport
extends EditingSupport {
    private String colName;
    private TableViewer properiesTableViewer;
    private ConnectionPropertyTable connectionPropertyTable;

    public ConnectionPropertyEditingSupport(TableViewer viewer, String colName, ConnectionPropertyTable table) {
        super((ColumnViewer)viewer);
        this.properiesTableViewer = viewer;
        this.colName = colName;
        this.connectionPropertyTable = table;
    }

    protected CellEditor getCellEditor(Object element) {
        return new TextCellEditor((Composite)this.properiesTableViewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return element instanceof ConnectionProperty;
    }

    protected Object getValue(Object element) {
        if (element instanceof ConnectionProperty) {
            if (this.colName.equals(GlobalMessageConstants.NAME)) {
                return ((ConnectionProperty)element).getName();
            }
            if (this.colName.equals(GlobalMessageConstants.VALUE)) {
                return ((ConnectionProperty)element).getValue();
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        String newName = (String)value;
        ConnectionProperty prop = (ConnectionProperty)element;
        if (!newName.equals(prop.getName())) {
            if (this.colName.equals(GlobalMessageConstants.NAME)) {
                this.setValueForColName(newName, element);
            } else if (this.colName.equals(GlobalMessageConstants.VALUE)) {
                this.setValueForColValue(newName, element);
            }
        }
    }

    private void setValueForColValue(String newName, Object element) {
        ((ConnectionProperty)element).setValue(newName);
        this.properiesTableViewer.refresh();
    }

    private void setValueForColName(String newName, Object element) {
        boolean duplicatedName = DBConnectionProperties.isConnectionPropertyNameDuplicated((String)newName, this.connectionPropertyTable.getListConnectionPropeties());
        if (!duplicatedName) {
            ((ConnectionProperty)element).setName(newName);
        } else {
            MessageDialog.openWarning((Shell)this.connectionPropertyTable.getShell(), (String)GlobalMessageConstants.WARN, (String)"The property name already exists.");
        }
        this.properiesTableViewer.refresh();
    }
}

