/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ForStatementWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstContentProviderAdapter;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.constants.GlobalMessageConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ForInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private static final String VARIABLE_LABEL = "Variable";
    private static final String COLLECTION_EXPRESSION_LABEL = "Expression";
    private final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions("for");
    private ForStatementWrapper forStatement;

    public ForInputBuilderDialog(Shell parentShell, ForStatementWrapper forStatement) {
        super(parentShell);
        this.forStatement = forStatement.clone();
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new AstContentProviderAdapter(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == ForInputBuilderDialog.this.forStatement) {
                    return new Object[]{ForInputBuilderDialog.this.forStatement.getVariable(), ForInputBuilderDialog.this.forStatement.getCollectionExpression()};
                }
                return new Object[0];
            }
        });
        this.tableViewer.setInput((Object)this.forStatement);
    }

    @Override
    public ForStatementWrapper getReturnValue() {
        return this.forStatement;
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_FOR_INPUT;
    }

    @Override
    protected void addTableColumns() {
        this.addTableColumnObject();
        this.addTableColumnValueType();
        this.addTableColumnValue();
    }

    private void addTableColumnValue() {
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValue.getColumn().setText(GlobalMessageConstants.VALUE);
        tableViewerColumnValue.getColumn().setWidth(300);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element != ForInputBuilderDialog.this.forStatement.getVariable()) {
                    return super.getText(element);
                }
                if (!ForStatementWrapper.isForLoopDummy(ForInputBuilderDialog.this.forStatement.getVariable())) {
                    return ForInputBuilderDialog.this.forStatement.getVariable().getName();
                }
                return "";
            }
        });
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected CellEditor getCellEditor(Object element) {
                if (element == ForInputBuilderDialog.this.forStatement.getVariable()) {
                    return new TextCellEditor((Composite)ForInputBuilderDialog.this.tableViewer.getTable());
                }
                return super.getCellEditor(element);
            }

            @Override
            protected Object getValue(Object element) {
                if (element != ForInputBuilderDialog.this.forStatement.getVariable()) {
                    return super.getValue(element);
                }
                if (!ForStatementWrapper.isForLoopDummy(ForInputBuilderDialog.this.forStatement.getVariable())) {
                    return ForInputBuilderDialog.this.forStatement.getVariable().getName();
                }
                return "";
            }

            @Override
            protected void setValue(Object element, Object value) {
                if (element == ForInputBuilderDialog.this.forStatement.getVariable()) {
                    if (!(value instanceof String)) {
                        return;
                    }
                    ParameterWrapper newVariable = new ParameterWrapper(Object.class, (String)value, ForInputBuilderDialog.this.forStatement);
                    newVariable.copyProperties(ForInputBuilderDialog.this.forStatement.getVariable());
                    ForInputBuilderDialog.this.forStatement.setVariable(newVariable);
                    this.getViewer().refresh();
                    return;
                }
                super.setValue(element, value);
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element != ForInputBuilderDialog.this.forStatement.getVariable()) {
                    return super.canEdit(element);
                }
                return !(ForInputBuilderDialog.this.forStatement.getCollectionExpression() instanceof ClosureListExpressionWrapper);
            }
        });
    }

    private void addTableColumnValueType() {
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider());
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes){

            @Override
            protected boolean canEdit(Object element) {
                return element != ForInputBuilderDialog.this.forStatement.getVariable();
            }
        });
    }

    private void addTableColumnObject() {
        TableViewerColumn tableViewerColumnObject = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnObject.getColumn().setText(GlobalMessageConstants.OBJECT);
        tableViewerColumnObject.getColumn().setWidth(100);
        tableViewerColumnObject.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element == ForInputBuilderDialog.this.forStatement.getCollectionExpression()) {
                    return ForInputBuilderDialog.COLLECTION_EXPRESSION_LABEL;
                }
                if (element == ForInputBuilderDialog.this.forStatement.getVariable()) {
                    return ForInputBuilderDialog.VARIABLE_LABEL;
                }
                return "";
            }
        });
    }
}

