/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.groovy.ast.statements;

import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.BooleanExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ComplexChildStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ElseStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.IfStatementWrapper;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ElseIfStatementWrapper
extends ComplexChildStatementWrapper {
    protected BooleanExpressionWrapper expression;

    public ElseIfStatementWrapper() {
        this(null);
    }

    public ElseIfStatementWrapper(IfStatementWrapper parentNodeWrapper) {
        super(parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(this);
    }

    public ElseIfStatementWrapper(IfStatement ifStatement, IfStatementWrapper parentNodeWrapper) {
        super((Statement)ifStatement, ElseIfStatementWrapper.initIfBlock(ifStatement), (ASTNodeWrapper)parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(ifStatement.getBooleanExpression(), (ASTNodeWrapper)this);
        this.lineNumber = this.expression.getLineNumber();
        this.columnNumber = this.expression.getColumnNumber() - 1;
        this.lastLineNumber = ifStatement.getIfBlock().getLastLineNumber();
        this.lastColumnNumber = ifStatement.getIfBlock().getLastColumnNumber() - 1;
        this.start = this.expression.getStart();
        this.end = ifStatement.getIfBlock().getEnd();
    }

    public ElseIfStatementWrapper(ElseIfStatementWrapper elseIfStatementWrapper, IfStatementWrapper parentNodeWrapper) {
        super(elseIfStatementWrapper, (ASTNodeWrapper)parentNodeWrapper);
        this.expression = new BooleanExpressionWrapper(elseIfStatementWrapper.getBooleanExpression(), (ASTNodeWrapper)this);
    }

    private static BlockStatement initIfBlock(IfStatement ifStatement) {
        Statement ifBlock = ifStatement.getIfBlock();
        if (ifBlock instanceof BlockStatement) {
            return (BlockStatement)ifBlock;
        }
        BlockStatement block = new BlockStatement();
        block.addStatement(ifBlock);
        return block;
    }

    public BooleanExpressionWrapper getBooleanExpression() {
        return this.expression;
    }

    public void setBooleanExpression(BooleanExpressionWrapper booleanExpression) {
        if (booleanExpression == null) {
            return;
        }
        booleanExpression.setParent(this);
        this.expression = booleanExpression;
    }

    @Override
    public String getText() {
        return "else if (" + this.getInputText() + ")";
    }

    @Override
    public IfStatementWrapper getParent() {
        return (IfStatementWrapper)super.getParent();
    }

    @Override
    public List<? extends ASTNodeWrapper> getAstChildren() {
        ArrayList<? extends ASTNodeWrapper> astNodeWrappers = new ArrayList<ASTNodeWrapper>();
        astNodeWrappers.add(this.expression);
        astNodeWrappers.addAll(super.getAstChildren());
        return astNodeWrappers;
    }

    @Override
    public ElseIfStatementWrapper clone() {
        return new ElseIfStatementWrapper(this, this.getParent());
    }

    @Override
    public BooleanExpressionWrapper getInput() {
        return this.getBooleanExpression();
    }

    @Override
    public String getInputText() {
        return this.getInput().getText();
    }

    @Override
    public boolean updateInputFrom(ASTNodeWrapper input) {
        if (input instanceof BooleanExpressionWrapper && !this.getBooleanExpression().isEqualsTo(input)) {
            this.setBooleanExpression((BooleanExpressionWrapper)input);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isAstNodeBelongToParentComplex(ASTNodeWrapper astNode) {
        return astNode instanceof ElseIfStatementWrapper || astNode instanceof ElseStatementWrapper;
    }
}

