/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.preferences;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.controller.EntityTagController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.util.EntityTagUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TestCaseSettingStore
extends BundleSettingStore {
    private static final String STORE_ID = "com.kms.katalon.composer.testcase";
    private static final String TAG_PROPERTY = "testCaseTag";

    public TestCaseSettingStore(String projectDir) {
        super(projectDir, STORE_ID, false);
    }

    public Set<String> getTestCaseTags() throws IOException {
        String tagsString = this.getString(TAG_PROPERTY, "");
        HashSet<String> tags = new HashSet();
        if (StringUtils.isBlank((String)tagsString)) {
            this.loadTestCaseTags();
        } else {
            tags = EntityTagUtil.parse((String)tagsString);
        }
        return tags;
    }

    public void saveTestCaseTags(Set<String> tags) throws GeneralSecurityException, IOException {
        String tagsString = EntityTagUtil.joinTags(tags);
        this.setStringProperty(TAG_PROPERTY, tagsString, false);
    }

    private void loadTestCaseTags() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        try {
            Set allTagsInProject = EntityTagController.getInstance().collectTagsFromAllTestCases(project);
            this.saveTestCaseTags(allTagsInProject);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

